import React from 'react';
import { observer } from 'mobx-react';
import { Form, Input, Button, DatePicker, Select } from 'antd';
import moment from 'moment';
import store from '../store';
import styles from './index.less';
const dateFormat = 'YYYY-MM-DD';
const { RangePicker } = DatePicker;
const FormItem = Form.Item;
const Option = Select.Option;
@observer
class Formchild extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      // 巡检状态
      inspectStatus: [
        {
          label: '全部',
          id: ''
        },
        {
          label: '待巡检',
          id: 0
        },
        {
          label: '已巡检',
          id: 1
        }
      ],
      // 巡检结果
      inspectResult: [
        {
          id: '',
          label: '全部'
        },
        {
          id: 1,
          label: '巡检通过'
        },
        {
          id: 2,
          label: '巡检拒绝'
        },
        {
          id: 3,
          label: '巡检拒绝且下线'
        }
      ]
    };
  }
  componentDidMount() {
    const { getadvertIndustryTags, getadvertPromoteTags } = store;
    getadvertIndustryTags();
    getadvertPromoteTags();
    this.handleSubmit();
  }
  handleSubmit = () => {
    const { getsecondReviewLists, changeParams } = store;
    const { getFieldsValue } = this.props.form;
    let params = getFieldsValue();
    params = Object.assign(params, {
      'dateRange.from': params['time'][0].format(dateFormat),
      'dateRange.to': params['time'][1].format(dateFormat),
      pageSize: 6,
      currentPage: 1 // 每次提交的时候页码重置
    });
    delete params.time;
    changeParams(params);
    getsecondReviewLists(params);
  }
  // 参数重置
  handleReset = () => {
    const { getsecondReviewLists, changeParams } = store;
    this.props.form.resetFields();
    const { getFieldsValue } = this.props.form;
    let _params = getFieldsValue();
    changeParams(_params);
    const {params} = store;
    _params = Object.assign(params, {
      'dateRange.from': params['time'][0].format(dateFormat),
      'dateRange.to': params['time'][1].format(dateFormat),
      pageSize: 6,
      currentPage: 1 // 每次提交的时候页码重置
    });
    delete _params.time;
    getsecondReviewLists(_params);
  }
  render() {
    const { advertIndustryTags, advertPromoteTags } = store;
    let _advertIndustryTags = [{tagNum: '', tagName: '全部'}, ...(advertIndustryTags.slice())];
    let _advertPromoteTags = [{tagNum: '', tagName: '全部'}, ...(advertPromoteTags.slice())];
    const { getFieldDecorator } = this.props.form;
    // 时间
    return (
      <div>
        <Form layout="inline">
          <FormItem label="时间">
            {getFieldDecorator('time', {
              initialValue: [moment().subtract(1, 'days'), moment().subtract(0, 'days')]
            })(
              <RangePicker format={dateFormat}/>
            )}
          </FormItem>
          <FormItem
            label="广告ID"
          >
            {getFieldDecorator('advertId', {
              initialValue: ''
            })(
              <Input />
            )}
          </FormItem>
          <FormItem
            label="广告名称"
          >
            {getFieldDecorator('advertName', {
              initialValue: ''
            })(
              <Input />
            )}
          </FormItem>
          <FormItem
            label="商品名称"
          >
            {getFieldDecorator('goodsName', {
              initialValue: ''
            })(
              <Input />
            )}
          </FormItem>
          <FormItem
            label="巡检状态"
          >
            {getFieldDecorator('inspectStatus', {
              initialValue: ''
            })(
              <Select style={{ width: 120 }}>
                {
                  this.state.inspectStatus.map((ele) => {
                    return (<Option key={ele.id} value={ele.id}>{ele.label}</Option>);
                  })
                }
              </Select>
            )}
          </FormItem>
          <FormItem
            label="巡检结果"
          >
            {getFieldDecorator('inspectResult', {
              initialValue: ''
            })(
              <Select style={{ width: 150 }}>
                {
                  this.state.inspectResult.map((ele) => {
                    return (<Option key={ele.id} value={ele.id}>{ele.label}</Option>);
                  })
                }
              </Select>
            )}
          </FormItem>
          <FormItem
            label="复审"
          >
            {getFieldDecorator('secondReviewer', {
              initialValue: ''
            })(
              <Input />
            )}
          </FormItem>
          <FormItem
            label="初审"
          >
            {getFieldDecorator('firstReviewer', {
              initialValue: ''
            })(
              <Input />
            )}
          </FormItem>
          <FormItem
            label="AE"
          >
            {getFieldDecorator('ae', {
              initialValue: ''
            })(
              <Input />
            )}
          </FormItem>
          <FormItem
            label="销售"
          >
            {getFieldDecorator('sale', {
              initialValue: ''
            })(
              <Input />
            )}
          </FormItem>
          <FormItem
            label="代理商名称"
          >
            {getFieldDecorator('agentName', {
              initialValue: ''
            })(
              <Input />
            )}
          </FormItem>
          <FormItem
            label="广告主名称"
          >
            {getFieldDecorator('advertMaster', {
              initialValue: ''
            })(
              <Input />
            )}
          </FormItem>
          <FormItem
            label="行业"
          >
            {getFieldDecorator('industryTag', {
              initialValue: ''
            })(
              <Select style={{ width: 150 }}>
                {
                  _advertIndustryTags.map((ele, index) => {
                    return (<Option key={ index } value={ele.tagNum}>{ele.tagName}</Option>);
                  })
                }
              </Select>
            )}
          </FormItem>
          <FormItem
            label="落地页标签"
          >
            {getFieldDecorator('promoteTag', {
              initialValue: ''
            })(
              <Select style={{ width: 150 }}>
                {
                  _advertPromoteTags.map((ele, index) => {
                    return (<Option key={ index } value={ele.tagNum}>{ele.tagName}</Option>);
                  })
                }
              </Select>
            )}
          </FormItem>
          <FormItem>
            <Button
              type="primary"
              className = {styles.sum_btn}
              onClick = { this.handleSubmit }
            >
              查询
            </Button>
            <Button
              onClick={this.handleReset}
            >
              重置
            </Button>
          </FormItem>
        </Form>
      </div>
    );
  }
}
const Innercheckform = Form.create({})(Formchild);

export default Innercheckform;
