import React from 'react';
import { Table, Select, Switch, Input, Icon, Button, Modal } from 'antd';
import fixNum from 'src/lib/dataFormate';
import { observer } from 'mobx-react';
import tableHoc from './tableHoc';
import textAreahoc from './textAreahoc';
import AddCaseModal from '../modals/addCase';
import ProgressModal from '../modals/progress';
import ReviewResultModal from '../modals/reviewResult';
import store from '../store';
import styles from './index.less';
const Option = Select.Option;
const TextArea = Input.TextArea;
const confirm = Modal.confirm;
// table处理状态枚举
const reviewResultArrItem = [
  { value: null, text: '待处理' },
  { value: 1, text: '调分成' },
  { value: 2, text: '下线' },
  { value: 3, text: '暂不处理' }
  // { value: 4, text: '暂不处理，加入限流包' },
  // { value: 5, text: '调分成，加入限流包' },
  // { value: 6, text: '下线，加入限流包' }
];
function formatNum(type, num) {
  if (isNaN(parseInt(num))) {
    return '-';
  }
  // null
  if (type === null) {
    return '-';
  }
  // 浮点数
  if (type === 'float') {
    return fixNum(num, 2);
  }
  // 整数
  if (type === 'int') {
    return fixNum(num, 0);
  }
  // 百分比
  if (type === '%') {
    return parseFloat((num * 100).toPrecision(12)) + '%';
  }
  // app-ad-consume 除以100
  if (type === '100') {
    let nums = num / 100;
    return fixNum(nums, 2);
  }
  return num;
}

const columns = [{
  title: '时间',
  dataIndex: 'curDate',
  key: 'curDate',
  fixed: 'left',
  width: 120
}, {
  title: '异常时间点',
  dataIndex: 'dHour',
  key: 'dHour',
  fixed: 'left',
  width: 100,
  render: (text, record, index) => { return text === '1' ? '1天' : text + '点'; }
}, {
  title: '广告位id *',
  dataIndex: 'slotId',
  key: 'slotId',
  fixed: 'left',
  width: 150,
  render: (text, record, index) => {
    const isOffline = record.dHour === '1';
    let href = `http://eye.dui88.com/tuia#!/tuiachartcenter/tuiatableview/119/${record.slotId}/${record.curDate}`;
    if (!isOffline) href = `http://eye.dui88.com/tuia#!/tuiachartcenter/tuiatableview/330/${record.slotId}/${record.curDate}`;
    return (
      <a target="_blank" href={href}>
        <p>{ record.slotId }</p>
        <p>{ record.slotName }</p>
      </a>
    );
  }
}, {
  title: '媒体id',
  dataIndex: 'appId',
  fixed: 'left',
  width: 100,
  render: (text, record, index) => {
    return (
      <div>
        <p>{ record.appId }</p>
        <p>{ record.appName }</p>
      </div>
    );
  }
}, {
  title: '运营',
  dataIndex: 'mediaName',
  key: 'mediaName',
  render: (text, record, index) => {
    return (
      <div>
        <p> 媒体运营：{ record.mediaName }</p>
        <p> 媒介运营：{ record.agentName }</p>
      </div>
    );
  }
}, {
  title: '综合信用分',
  dataIndex: 'creditsScore',
  key: 'creditsScore',
  render: (text, record, index) => {
    return text || '-';
  }
},
// {
//   title: '处理人',
//   dataIndex: 'preRiskReviewer',
//   key: 'preRiskReviewer',
//   render: (text, record, index) => {
//     const { _riskReviewer } = store;
//     return (
//       tableHoc('preRiskReviewer', {preRiskReviewer: record.preRiskReviewer, riskAllId: record.id, id: record.riskReviewId})(
//         <Select
//           style={{ width: '100%' }}
//           placeholder="处理人"
//           defaultValue={text}
//         >
//           {_riskReviewer && _riskReviewer.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
//         </Select>
//       )
//     );
//   }
// },
{
  title: '作弊消耗',
  dataIndex: 'cheatFee',
  key: 'cheatFee',
  render: (text, record, index) => {
    return formatNum('100', text);
  }
}, {
  title: '作弊消耗占比',
  dataIndex: 'cheatFeeRate',
  key: 'cheatFeeRate',
  render: (text, record, index) => {
    return formatNum('%', text);
  }
}, {
  title: '广告位消耗',
  dataIndex: 'adConsume',
  key: 'adConsume',
  render: (text, record, index) => {
    return formatNum('100', text);
  }
}, {
  title: '媒体消耗',
  dataIndex: 'appAdConsume',
  key: 'appAdConsume',
  render: (text, record, index) => {
    return formatNum('100', text);
  }
}, {
  title: '分成比例',
  dataIndex: 'divideRate',
  key: 'divideRate',
  render: (text, record, index) => {
    return formatNum('%', text);
  }
}, {
  title: '命中规则 *',
  dataIndex: 'rules',
  key: 'rules',
  render: (text, record, index) => {
    const isOffline = record.dHour === '1';
    let href = `http://eye.dui88.com/tuia#!/tuiachartcenter/tuiatableview/118/${record.slotId}/${record.curDate}`;
    if (!isOffline) href = `http://eye.dui88.com/tuia#!/tuiachartcenter/tuiatableview/329/${record.slotId}/${record.curDate}`;
    return <a target="_blank" href={href}>{text}</a>;
  }
}, {
  title: '累计处理次数 *',
  dataIndex: 'reviewCount',
  key: 'reviewCount',
  render: (text, record, index) => {
    const { updateReviewResultModalObj } = store;
    const showReviewResultModal = () => {
      updateReviewResultModalObj({record: record, show: true});
    };
    return <a onClick={showReviewResultModal}>{text}</a>;
  }
}, {
  title: '作弊等级',
  dataIndex: 'cheatGrade',
  key: 'cheatGrade',
  render: (text, record, index) => {
    return `${text}级作弊` || '-';
  }
}, {
  title: '初步处理结果',
  dataIndex: 'preResult',
  key: 'preResult',
  render: (text, record, index) => {
    const date = new Date();
    let disabled = date.getHours() >= 14 && date.getHours() <= 23;
    return (
      tableHoc('preResult', {preResult: record.preResult, riskAllId: record.id, id: record.riskReviewId})(
        <Select
          style={{ width: '100%' }}
          placeholder="初步处理结果"
          defaultValue={text}
          disabled={disabled}
        >
          {reviewResultArrItem && reviewResultArrItem.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
        </Select>
      )
    );
  }
}, {
  title: '媒体处理意见',
  dataIndex: 'mediaDealOpinion',
  key: 'mediaDealOpinion',
  render: (text, record, index) => {
    let opinion = text === 1 ? '同意' : text === 0 ? '不同意' : '-';
    return opinion || '-';
  }
}, {
  title: '最终处理金额',
  dataIndex: 'finalDealMoney',
  key: 'finalDealMoney',
  render: (text, record, index) => {
    return ((text) / 100).toFixed(2) || '-';
  }
},
// {
//   title: '是否上级复审',
//   dataIndex: 'isSuperiorReview',
//   key: 'isSuperiorReview',
//   render: (text, record, index) => {
//     let disabled = !(record.preResult !== null && record.reviewResult === null);
//     // 兼容antd Switch
//     if (text === 1) {
//       text = true;
//     } else {
//       text = false;
//     }
//     return (
//       tableHoc('isSuperiorReview', {preResult: record.isSuperiorReview, riskAllId: record.id, id: record.riskReviewId})(
//         <Switch defaultChecked={text} disabled={disabled}/>
//       )
//     );
//   }
// }, {
//   title: '最终处理结果',
//   dataIndex: 'reviewResult',
//   render: (text, record, index) => {
//     let disabled = record.isSuperiorReview === null || record.isSuperiorReview !== 1;
//     return (
//       tableHoc('reviewResult', {reviewResult: record.reviewResult, riskAllId: record.id, id: record.riskReviewId})(
//         <Select
//           style={{ width: '100%' }}
//           placeholder="最终处理结果"
//           // 0还是null处理转化
//           // defaultValue={text === 0 ? null : text}
//           defaultValue={text}
//           disabled={disabled}
//         >
//           {reviewResultArrItem && reviewResultArrItem.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
//         </Select>
//       )
//     );
//   }
// }, {
//   title: '通知媒体运营',
//   dataIndex: 'needNotify',
//   key: 'needNotify',
//   render: (text, record, index) => {
//     const date = new Date();
//     let disabled = date.getHours() >= 14 && date.getHours() <= 23;
//     return (
//       tableHoc('needNotify', {riskAllId: record.id, id: record.riskReviewId})(
//         <Switch defaultChecked={text} disabled={disabled}/>
//       )
//     )
//     ;
//   }
// },
{
  title: '是否进入案列库',
  dataIndex: 'isInExample',
  key: 'isInExample',
  render: (text, record, index) => {
    if (text === 1) {
      text = true;
    } else {
      text = false;
    }
    return tableHoc('isInExample', {isInExample: record.isInExample, riskAllId: record.id, id: record.riskReviewId}, record)(
      <Switch
        defaultChecked={text}
        disabled={text}
      />
    );
  }
}, {
  title: '查看进度',
  dataIndex: 'currentProgress',
  key: 'currentProgress',
  render: (text, record, index) => {
    const { updateProcessModalObj, getProcessModal } = store;
    const showProcessModal = (params) => {
      updateProcessModalObj({record: record});
      getProcessModal({riskAllId: record.id});
    };
    return <a className={styles.link} onClick={showProcessModal}>{ record.currentProgress }</a>;
  }
}, {
  title: '备注',
  dataIndex: 'reviewRemarks',
  key: 'reviewRemarks',
  render: (text, record, index) => {
    return textAreahoc('reviewRemarks', {reviewRemarks: record.reviewRemarks, riskAllId: record.id, id: record.riskReviewId}, Object.assign({}, record, {tableTitle: '备注'}))(
      <TextArea rows={1}/>
    );
  }
}
];

@observer
class CaseTable extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false
    };
  }
  handlePartition() {
    const { configValue, getUpdateOrInsert } = store;
    let content = '';
    let params = {
      configKey: 'batch.partition.switch'
    };
    if (configValue === '0') {
      content = '确认后，系统将会在11:30、14:00对作弊媒体的分成自动调整';
      params.configValue = '1';
    }
    if (configValue === '1') {
      content = '取消后，系统将不会在11:30、14:00对作弊媒体的分成自动调整';
      params.configValue = '0';
    }
    confirm({
      title: '提示',
      content: content,
      okText: '确定',
      okType: 'danger',
      cancelText: '取消',
      onOk() {
        getUpdateOrInsert(params);
      },
      onCancel() {
        console.log('you chose close!');
      }
    });
  }
  componentDidMount() {
    const { getConfigValue } = store;
    getConfigValue();
  }
  render() {
    const { dataIsLoading, dataList, addCaseModalObj, processModalObj, reviewResultModalObj } = store;
    let _dataSource = dataList.list ? dataList.list.slice() : [];
    // 分页配置信息
    const paganationOpts = {
      defaultPageSize: 6,
      current: store.params.currentPage,
      total: dataList.totalCount,
      showTotal: (total) => { return `共${total}条`; },
      onChange: page => {
        const { getDataList, updateParams } = store;
        updateParams({currentPage: page});
        getDataList();
      }
    };
    const { downReviewDataTable, params, configValue, finalDealMoney } = store;
    let isBatchPartition = '';
    isBatchPartition = configValue === '0' ? '确认批量调分成' : '取消批量调分成';
    const buttonType = configValue === '0' ? 'primary' : '';
    const date = new Date();
    let disabled = date.getHours() >= 14 && date.getHours() <= 23;
    return (
      <div>
        <Icon type="download" className={styles.down} onClick={downReviewDataTable}/>
        <Button
          disabled={disabled}
          className={styles.buttonClick}
          type={buttonType}
          htmlType="submit"
          onClick={this.handlePartition}
        >
          {isBatchPartition}
        </Button>
        {params.type === 2 ? <span>统计项：最终处理金额：{(finalDealMoney / 100).toFixed(2)}元</span> : null}
        <Table
          className="audiTableStyle"
          scroll={{ x: 2900 }}
          rowKey="id"
          columns={columns}
          dataSource={_dataSource}
          pagination={true}
          pagination={paganationOpts}
          loading={dataIsLoading}
          locale={{ emptyText: '暂无数据' }}
        />
        {addCaseModalObj.show ? <AddCaseModal addCaseModalObj={addCaseModalObj}/> : null }
        {processModalObj.show ? <ProgressModal processModalObj={processModalObj}/> : null }
        {reviewResultModalObj.show ? <ReviewResultModal reviewResultModalObj={reviewResultModalObj}/> : null }
      </div>
    );
  }
}

export default CaseTable;
