import { observable, action } from 'mobx';

import common from 'src/lib/common';
import moment from 'moment';

class State {
  // loading
  @observable
  dataIsLoading = false;
  // 请求参数
  @observable
  params = {
    time: [moment().subtract(1, 'days'), moment().subtract(0, 'days')],
    startTime: '',
    endTime: '',
    slotId: '',
    appId: '',
    riskReviewer: '',
    cheatGrade: '',
    // reviewResult: '',
    preResult: '',
    type: '3',
    pageSize: 6,
    currentPage: 1
  };
  // 更新params
  @action
  updateParams = (params) => {
    this.params = Object.assign({}, this.params, params);
  }
  // 处理人search用
  @observable
  riskReviewer = []
  // 处理人table用
  @observable
  _riskReviewer = []
  // 请求处理人
  @action
  getRiskReviewer = () => {
    // 获取处理人
    common.fetch('/riskReview/findAdminsReview').then(res => {
      this.dataSource = (res.data && res.data.stickContentVoList) || [];
      let riskReviewer = [{value: '', text: '全部'}];
      let _riskReviewer = [{value: null, text: '待定'}];
      res.data.forEach((item) => {
        riskReviewer.push({
          value: item.name,
          text: item.name
        });
        _riskReviewer.push({
          value: item.name,
          text: item.name
        });
      });
      this.riskReviewer = riskReviewer;
      this._riskReviewer = _riskReviewer;
    });
  }
  // cheatGrade作弊等级条数
  @observable
  cheatGrade = {};

  // getcheatGrade 获取作弊等级条数
  @action
  getcheatGrade = () => {
    common.fetch('/riskReview/queryCountShow', this.params, 'get')
      .then(res => {
        this.dataIsLoading = false;
        this.cheatGrade = res.data || {};
      });
  }
  // table数据
  @observable
  dataList = {
    list: []
  };
  // 获取table数据
  @action
  getDataList = () => {
    this.dataIsLoading = true;
    common.fetch('/riskReview/queryPage', this.params, 'get')
      .then(res => {
        this.dataIsLoading = false;
        this.dataList = res.data || ({
          list: []
        });
      });
  }
  @observable
  configValue = '0'
  // 查询是否批量调分成
  @action
  getConfigValue = () => {
    let params = {
      configKey: 'batch.partition.switch'
    };
    common.fetch('/systemConfig/getConfigValue', params, 'get')
      .then(res => {
        this.configValue = res.data || '';
      });
  }
  // 确认是否批量调分成
  @action
  getUpdateOrInsert = (params) => {
    common.fetch('/systemConfig/updateOrInsert', params, 'post', {isJson: true})
      .then(res => {
        this.getConfigValue();
      });
  }
  // 查询最终处理金额
  @observable
  finalDealMoney = 0.00
  @action
  getFinalDealMoney = () => {
    common.fetch('/riskReview/getFinalDealMoney', this.params, 'get')
      .then(res => {
        this.finalDealMoney = res.data || '';
      });
  }
  // 更新添加操作.
  @action
  addOrUpdate = (params) => {
    common.fetch('/riskReview/addOrUpdate', params, 'post', {isJson: true})
      .then(res => {
        common.handleSuccess('修改成功！');
        this.getDataList();
      });
  }
  // addCaseModal 添加案例弹框
  @observable
  addCaseModalObj = {
    show: false,
    record: {}
  }
  // 更新addCaseModal状态
  @action
  updateAddCaseModalObj = (arg) => {
    this.addCaseModalObj = Object.assign({}, this.addCaseModalObj, arg);
  }
  // 保持addCaseModal状态
  @action
  addCase = (params) => {
    this.addCaseModalObj.show = false;
    let id = params.id;
    params.id = null;
    common.fetch('/riskExample/addOrUpdate', params, 'post', {isJson: true})
      .then(res => {
        this.addOrUpdate({
          id: id,
          isInExample: 1,
          riskAllId: params.riskAllId
        });
      });
  }
  // processModal 添加案例弹框
  @observable
  processModalObj = {
    show: false,
    record: {},
    list: []
  }
  // 更新processModal状态
  @action
  updateProcessModalObj = (arg) => {
    this.processModalObj = Object.assign({}, this.processModalObj, arg);
  }
  // 保持processModalObj状态
  @action
  getProcessModal = (params) => {
    common.fetch('/riskReview/queryReviewHisList', params, 'get')
      .then(res => {
        this.processModalObj.list = res.data;
        this.processModalObj.show = true;
      });
  }
  // 处理结果弹框
  @observable
  reviewResultModalObj = {
    show: false,
    record: {},
    list: [],
    totalCount: 0,
    currentPage: 1
  }
  // 更新reviewResultModal状态
  @action
  updateReviewResultModalObj = (arg) => {
    this.reviewResultModalObj = Object.assign({}, this.reviewResultModalObj, arg);
  }
  // 保持reviewResultModal状态
  @action
  getReviewResultModal = (params) => {
    common.fetch('/riskReview/handleRecord', params, 'get')
      .then(res => {
        this.reviewResultModalObj.list = res.data.list;
        this.reviewResultModalObj.totalCount = res.data.totalCount;
      });
  }
  // downReviewResultTable
  // 导出
  @action
  downReviewResultTable = (params) => {
    window.open('/riskReview/exportHandleRecords?' + common.concatUrl(params));
  }
  // 导出 风控
  @action
  downReviewDataTable = () => {
    window.open('riskReview/exportReviewData?' + common.concatUrl(this.params));
  }
}

const store = new State();
export default store;
