import React from 'react';

import common from 'src/lib/common';
import store from 'src/containers/riskmng/auditcase/store';
import {
  Icon,
  Upload,
  Modal
} from 'antd';

import './index.less';

const url = '/upload/uploadImg';
class UploadImage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      previewVisible: false,
      previewImage: props.value
    };
  }
  // 上传前进行检查
  handleBeforeUpload = (file, fileList) => {
    const { width, height, fileLimit } = this.props;
    const imgTypeSize = {
      width: parseInt(width, 10) || undefined,
      height: parseInt(height, 10) || undefined
    };
    // 检查文件是否是图片
    if (!this.checkIsImage(file)) {
      common.handleError('上传的必须是jpg, jpeg, png, gif类型的图片');
      return false;
    }
    // 检查文件大小是否超过限制
    if (!this.checkFileLimit(file)) {
      const fileLimitText = fileLimit >= (1 * 1024 * 1024) ? `${(fileLimit / 1024 / 1024)}MB` : `${(fileLimit / 1024)}KB`;
      common.handleError(`图片必须小于${fileLimitText}`);
      return false;
    }
    // 检查文件尺寸是否超过限制
    return this.checkImageSize(file, imgTypeSize);
  }
  handleChange = (file) => {
    let fileList = file.fileList;
    this.props.onChange({ fileList });
    // 如果已经是done状态，那么就设置数据
    if (file.file.status === 'done') {
      let uploadList = [];
      fileList.map(item => {
        if (item.response) {
          uploadList.push(item);
        }
      });
      const res = uploadList[0].response;
      if (res.data === false) {
        common.handleSuccess('上传图片成功');
      } else {
        common.handleError(res['desc']);
      }
    } else if (file.file.status === 'error') {
      common.handleError('上传图片请求出错，请稍候重试');
    }
  }
  // 处理预览框取消事件
  handleCancel = () => this.setState({ previewVisible: false })
  // 处理预览按钮点击事件
  handlePreview = (file) => {
    this.setState({
      previewImage: file.url || file.thumbUrl,
      previewVisible: true
    });
  }
  // 校验图片的大小是否合规
  checkImageSize = (file, imgTypeSize) => {
    return new Promise(function(resolve, reject) {
      function check(width, height) {
        if (
          (width === imgTypeSize.width || !imgTypeSize.width) &&
          (height === imgTypeSize.height || !imgTypeSize.height)
        ) {
          resolve(file);
        } else {
          common.handleError(
            '图片大小不对，要求尺寸为' +
              (imgTypeSize.width || '宽度不限') +
              '*' +
              (imgTypeSize.height || '高度不限') +
              ' 像素'
          );
        }
      }
      // 读取图片数据
      if (typeof window.FileReader === 'function') {
        // 读取图片数据
        const reader = new window.FileReader();
        reader.onload = function(e) {
          const data = e.target.result;
          // 加载图片获取图片真实宽度和高度
          const image = new window.Image();
          image.onload = function() {
            const width = image.width;
            const height = image.height;
            check(width, height);
          };
          image.src = data;
        };
        reader.readAsDataURL(file);
      } else {
        common.handleError('你的浏览器不支持图片大小判断，请更换现代浏览器，例如Chrome');
      }
    });
  }
  // 限制文件格式为图片
  checkIsImage = (file) => {
    const fileName = file.name;
    return !!fileName.match(/.jpg|.jpeg|.png|.gif/);
  }
  // 限制文件大小
  checkFileLimit = (file) => {
    const { fileLimit } = this.props;
    if (!fileLimit) {
      return true;
    }
    return fileLimit > file.size;
  }
  handleRemove = (file) => {
    const { deletePhoto } = store;
    let id;
    if (!file.response) {
      id = file.uid;
    } else {
      id = -1;
    }
    let params = {
      id: id
    };
    return new Promise((resolve, reject) => {
      Modal.confirm({
        title: '提示',
        content: '确认修改?',
        okText: '确定',
        okType: 'danger',
        cancelText: '取消',
        onOk() {
          deletePhoto(params.id).then(resolve());
        },
        onCancel() {
          console.log('you chose close!');
          resolve(false);
        }
      });
    });
  }
  render() {
    const { fileList = [] } = this.props;
    const { previewVisible, previewImage } = this.state;
    const uploadButton = (
      <div>
        <Icon type="plus" />
      </div>
    );
    return (
      <div className="clearfix">
        <Upload
          className="uploadStyle"
          action={url}
          listType="picture-card"
          beforeUpload={this.handleBeforeUpload}
          fileList={fileList}
          onPreview={this.handlePreview}
          onChange={this.handleChange}
          onRemove={this.handleRemove}
        >
          {fileList.length >= 3 ? null : uploadButton}
        </Upload>
        <Modal visible={previewVisible} footer={null} onCancel={this.handleCancel} className="modalStyle">
          <img alt="图片" className="width_100_percent" src={previewImage || (fileList.length && fileList.url)} />
        </Modal>
      </div>
    );
  }
}

export default UploadImage;
