import React from 'react';
import { observer } from 'mobx-react';
import { transaction } from 'mobx';

import {
  Modal,
  Button
} from 'antd';

import FlowScoreForm from '../forms/flowAndScore';

import store from '../store';

@observer
class EditModal extends React.Component {
  trans2arr(arr) {
    return arr && arr.filter(item => item !== undefined || item !== null);
  }
  handleOk = () => {
    const {
      checkRuleName,
      formRef
    } = store;
    const { form } = formRef.props;
    const { validateFields } = form;
    validateFields((errors, values) => {
      if (errors) {
        console.log(errors);
      } else {
        const fieldIdArr = values.fieldId ? values.fieldId.concat(this.trans2arr(values.new_fieldId)) : this.trans2arr(values.new_fieldId);
        const operationArr = values.operation ? values.operation.concat(this.trans2arr(values.new_operation)) : this.trans2arr(values.new_operation);
        const thresholdArr = values.threshold ? values.threshold.concat(this.trans2arr(values.new_threshold)) : this.trans2arr(values.new_threshold);
        const conditionsArr = [];
        for (let i = 0; i < values.conditions.length; i++) {
          conditionsArr.push({fieldId: fieldIdArr[i], operation: operationArr[i], threshold: thresholdArr[i]});
        }
        let params = {
          id: this.props.editObj.id ? this.props.editObj.id : '',
          name: values.name,
          decision: values.decision ? values.decision : '',
          mode: values.mode,
          status: 0,
          type: parseInt(this.props.type),
          conditions: conditionsArr.slice()
        };
        let isEdit = this.props.isEdit;
        transaction(() => {
          // 保存数据,设置内容为已改变并且隐藏弹窗
          checkRuleName(params, isEdit).then(this.props.closeModal);
        });
      }
    });
  }
  handleCancel = () => {
    this.props.closeModal();
  };
  render() {
    const { saveFormRef } = store;
    return (
      <Modal
        title={ this.props.isEdit ? '编辑规则' : '新建规则'}
        width={700}
        visible={true}
        maskClosable={false}
        onOk={this.handleOk}
        onCancel={this.handleCancel}
        okText="保存"
        cancelText="取消"
        footer={[
          <Button key="back" onClick={this.handleCancel}>取消</Button>,
          <Button key="submit" type="primary" onClick={this.handleOk}>保存</Button>
        ]}
      >
        <FlowScoreForm editObj={this.props.editObj} type={this.props.type} wrappedComponentRef={saveFormRef}/>
      </Modal>
    );
  }
}

export default EditModal;
