import { observable, action } from 'mobx';
import common from 'src/lib/common';
import { Modal, message } from 'antd';

const confirm = Modal.confirm;

class State {
  @observable
  dataIsLoading = false;
  // 请求参数
  @observable
  params = {
    pageSize: 10,
    name: '',
    currentPage: 1
  };
  // 更新params
  @action
  updateParams = (params) => {
    this.params = Object.assign({}, this.params, params);
  }
  // table数据
  @observable
  dataList = {
    list: []
  };
  // 获取table数据
  @action
  getDataList = () => {
    this.dataIsLoading = true;
    let params = Object.assign({}, this.params);
    common.fetch('/engineField/queryPage', params, 'get')
      .then(res => {
        this.dataIsLoading = false;
        this.dataList = res.data || ({
          list: []
        });
      });
  }
  // 获取所有场景
  @observable
  sceneIdsArr = [];
  // 获取table数据
  @action
  getAllScence = () => {
    common.fetch('/engineScene/queryAllScene', {}, 'get')
      .then(res => {
        this.sceneIdsArr = res.data;
      });
  }
  // 校验字段名称是否重复
  @action
  checkFieldName = (params, isEdit, name) => {
    return new Promise((resolve) => {
      common.fetch('/engineField/checkFieldByScene', {name: name}, 'post', {isJson: true})
        .then(res => {
          if (res.data === false) {
            resolve();
            isEdit ? this.updateFieldList(params) : this.addFieldList(params);
          } else {
            message.warning('字段名称已存在!');
          }
        });
    });
  }
  // 添加字段
  @action
  addFieldList = (params) => {
    common.fetch('/engineField/add', params, 'post', {isJson: true})
      .then(res => {
        this.getDataList();
      });
  }
  // 更新字段
  @action
  updateFieldList = (params) => {
    return new Promise((resolve) => {
      common.fetch('/engineField/update', params, 'post', {isJson: true})
        .then(res => {
          resolve();
          this.getDataList();
        });
    });
  }
  // 删除字段
  @action
  deleteField = (name) => {
    common.fetch('/engineField/delete', {name: name}, 'post', {isJson: true})
      .then(res => {
        common.handleSuccess('删除成功！');
        this.getDataList();
      });
  }
  // 校验该字段下有无关联规则
  @action
  checkIsRule = (id, name) => {
    common.fetch('engineField/existCdt', {fieldId: id}, 'get')
      .then(res => {
        if (res.data === false) {
          confirm({
            title: '提示',
            content: '确认删除?',
            okText: '确定',
            okType: 'danger',
            cancelText: '取消',
            onOk: () => {
              this.deleteField(name);
            },
            onCancel() {
              console.log('you chose close!');
            }
          });
        } else {
          message.warning('字段已关联规则，无法删除!');
        }
      });
  }
  // 判断字段是否在用
  @observable
  isFieldArr = [];
  @action
  checkField = (params) => {
    common.fetch('/engineField/getFieldUsed', params, 'get')
      .then(res => {
        this.isFieldArr = res.data;
      });
  }
  @action
  clearFieldArr = () => {
    this.isFieldArr = [];
  }
}

const store = new State();
export default store;
