import React from 'react';
import store from '../store';
import { Modal, Popover } from 'antd';
const confirm = Modal.confirm;
export default function change(key, params, record) {
  return function(Wapper) {
    const { addOrUpdate, getDataList } = store;
    class NewComponent extends React.Component {
      constructor(props) {
        super(props);
        this.state = {
          value: record[key]
        };
      }
      onBlur = (value) => {
        params[key] = this.state.value;
        this.showConfirm(params);
      }
      onChange = (evt) => {
        this.setState({
          value: evt.target.value
        });
      }
      // 二次确认框
      showConfirm = (params) => {
        confirm({
          title: '提示',
          content: '确认修改?',
          okText: '确定',
          okType: 'danger',
          cancelText: '取消',
          onOk() {
            addOrUpdate(params);
          },
          onCancel() {
            getDataList();
          }
        });
      }
      render() {
        let CopyWapper = React.cloneElement(
          Wapper,
          {
            value: this.state.value,
            onBlur: this.onBlur,
            onChange: this.onChange
          }
        );
        return (
          <Popover overlaystyle = {{maxWidth: '200px', wordWrap: 'break-word'}} title={record.tableTitle} placement = "left" content={this.state.value ? this.state.value : '暂无'}>
            {CopyWapper}
          </Popover>
        );
      }
    }
    return <NewComponent/>;
  };
}
