import React from 'react';
import { observer } from 'mobx-react';
import styles from './index.less';
import store from '../../store';
import moment from 'moment';
import {
  Table,
  Icon,
  Modal,
  Button,
  DatePicker
} from 'antd';
const dateFormat = 'YYYY-MM-DD';
const { RangePicker } = DatePicker;
// 处理状态枚举
const reviewResultArr = [
  { value: 0, label: '待处理' },
  { value: 1, label: '调分成' },
  { value: 2, label: '下线' },
  { value: 3, label: '暂不处理' },
  { value: 4, label: '暂不处理，加入限流包' },
  { value: 5, label: '调分成，加入限流包' },
  { value: 6, label: '下线，加入限流包' }
];

const cheatGradeArr = [
  { value: '0', label: '0级作弊' },
  { value: '1', label: '1级作弊' },
  { value: '2', label: '2级作弊' },
  { value: '3', label: '3级作弊' },
  { value: '4', label: '4级作弊' },
  { value: '5', label: '5级作弊' },
  { value: '6', label: '6级作弊' }
];
// 获取 作弊等级
function getCheatGradeArr(value) {
  let label = '';
  cheatGradeArr.forEach((item) => {
    if (item.value === value) {
      label = item.label;
    }
  });
  return label;
}
// 获取 处理状态
function getReviewResult(value) {
  let label = '';
  reviewResultArr.forEach((item) => {
    if (item.value === value) {
      label = item.label;
    }
  });
  return label;
}
const columns = [{
  title: '日期',
  dataIndex: 'curDate',
  key: 'curDate'
}, {
  title: '作弊等级',
  dataIndex: 'cheatGrade',
  key: 'cheatGrade',
  render: (text, record, index) => {
    return (<div>{getCheatGradeArr(text)}</div>);
  }
}, {
  title: '初步处理结果',
  dataIndex: 'preResult',
  key: 'preResult',
  render: (text, record, index) => {
    return (<div>{getReviewResult(text)}</div>);
  }
}, {
  title: '初步处理人',
  dataIndex: 'preRiskReviewer',
  key: 'preRiskReviewer'
}, {
  title: '最终处理结果',
  dataIndex: 'reviewResult',
  key: 'reviewResult',
  render: (text, record, index) => {
    return (<div>{getReviewResult(text)}</div>);
  }
}, {
  title: '最终处理人',
  dataIndex: 'riskReviewer',
  key: 'riskReviewer'
}, {
  title: '备注',
  dataIndex: 'reviewRemarks',
  key: 'reviewRemarks'
}];
@observer
class ReviewResult extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false,
      time: [moment().subtract(30, 'days'), moment().subtract(0, 'days')]
    };
  }
  componentDidMount() {
    this.search(1);
  };
  search = (currentPage) => {
    const { getReviewResultModal, updateReviewResultModalObj } = store;
    let params = {
      slotId: this.props.reviewResultModalObj.record.slotId,
      appId: this.props.reviewResultModalObj.record.appId,
      startTime: this.state.time[0].format(dateFormat),
      endTime: this.state.time[1].format(dateFormat),
      currentPage: currentPage,
      pageSize: 6
    };
    updateReviewResultModalObj({currentPage: currentPage});
    getReviewResultModal(params);
  };
  // 时间变了重新拉数据
  timeChange = (date, dateString) => {
    this.setState({
      time: date
    }, () => {
      this.search(1);
    });
  }
  // 近30天
  nearSearch = () => {
    this.setState({
      time: [moment().subtract(30, 'days'), moment().subtract(0, 'days')]
    }, () => {
      this.search(1);
    });
  }
  handleCancel = () => {
    const { updateReviewResultModalObj } = store;
    updateReviewResultModalObj({show: false});
  }
  downTable = () => {
    const { downReviewResultTable } = store;
    let params = {
      slotId: this.props.reviewResultModalObj.record.slotId,
      appId: this.props.reviewResultModalObj.record.appId,
      startTime: this.state.time[0].format(dateFormat),
      endTime: this.state.time[1].format(dateFormat)
    };
    downReviewResultTable(params);
  }
  render() {
    const { dataIsLoading, reviewResultModalObj } = store;
    let _dataSource = reviewResultModalObj.list.slice();
    // 分页配置信息
    const paganationOpts = {
      defaultPageSize: 6,
      current: store.reviewResultModalObj.currentPage,
      onChange: page => {
        this.search(page);
      }
    };
    return (
      <Modal
        title="处理记录"
        width={1000}
        visible={true}
        onCancel={this.handleCancel}
        footer={<div></div>}
      >
        <div className={styles.info}>
          <p>广告位id：{this.props.reviewResultModalObj.record.slotId}</p>
          <p>广告位名称：{this.props.reviewResultModalObj.record.slotName}</p>
        </div>
        <RangePicker
          onChange={this.timeChange}
          defaultValue={this.state.time}
          format={dateFormat}
        />
        <Button
          type="primary"
          htmlType="submit"
          className={styles.near}
          onClick={this.nearSearch}
        >
          近30天
        </Button>
        <Icon type="download" className={styles.down} onClick={this.downTable}/>
        <Table
          scroll={{ x: 900 }}
          rowKey="id"
          columns={columns}
          dataSource={_dataSource}
          pagination={true}
          loading={dataIsLoading}
          pagination={paganationOpts}
        />
      </Modal>
    );
  }
}
export default ReviewResult;
