import React from 'react';
import { Table, Select, Button, Modal, Icon } from 'antd';
import fixNum from 'src/lib/dataFormate';
import { observer } from 'mobx-react';
import tableHoc from './tableHoc';
import textAreahoc from './textAreahoc';
import imgView from './imgView';
import store from '../store';
import AddAndEditModal from '../modals/addAndEditModals';
import ReviewResultModal from '../modals/reviewResult';
import styles from './index.less';

const Option = Select.Option;
const confirm = Modal.confirm;

// 状态枚举
const statusArr = [{
  value: 0,
  text: '待研究'
}, {
  value: 1,
  text: '研究完成'
}];
function formatNum(type, num) {
  if (isNaN(parseInt(num))) {
    return '-';
  }
  // null
  if (type === null) {
    return '-';
  }
  // 浮点数
  if (type === 'float') {
    return fixNum(num, 2);
  }
  // 整数
  if (type === 'int') {
    return fixNum(num, 0);
  }
  // 百分比
  if (type === '%') {
    return parseFloat((num * 100).toPrecision(12)) + '%';
  }
  // app-ad-consume 除以100
  if (type === '100') {
    let nums = num / 100;
    return fixNum(nums, 2);
  }
  return num;
}
@observer
class AuditCaseTable extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false
    };
  }
  pageChange = (page, pageSize) => {
    const { updateParams, getDataList } = store;
    updateParams({
      currentPage: page
    });
    getDataList();
  }
  // 新增按钮点击事件
  handleAddBtn = () => {
    const { showOrHiddenAddAndEditModal } = store;
    showOrHiddenAddAndEditModal(1);
  }
  // 编辑按钮点击事件
  handleEditBtn = (record) => {
    const { showOrHiddenAddAndEditModal, getPhoto } = store;
    showOrHiddenAddAndEditModal(1, record);
    let params = {
      id: record.exampleId
    };
    getPhoto(params.id);
  }
  delCase = (id) => {
    const { delCase } = store;
    confirm({
      title: '提示',
      content: '确认修改?',
      okText: '确定',
      okType: 'danger',
      cancelText: '取消',
      onOk() {
        delCase(id);
      },
      onCancel() {
        console.log('you chose close!');
      }
    });
  }
  render() {
    const { dataIsLoading, dataList, addCaseModalObj, reviewResultModalObj } = store;
    let _dataSource = dataList.list ? dataList.list.slice() : [];
    const columns = [{
      title: '添加时间',
      dataIndex: 'gmtCreate',
      key: 'gmtCreate',
      fixed: 'left',
      width: 120
    }, {
      title: '问题时间点',
      dataIndex: 'curDate',
      key: 'curDate',
      fixed: 'left',
      width: 120
    }, {
      title: '广告位id',
      dataIndex: 'slotId',
      key: 'slotId',
      fixed: 'left',
      width: 150,
      render: (text, record, index) => {
        let href = '';
        if (record.dHour === '1') href = `http://eye.dui88.com/tuia#!/tuiachartcenter/tuiatableview/119/${record.slotId}/${record.curDate}`;
        if (record.dHour !== '' && record.dHour !== '1') href = `http://eye.dui88.com/tuia#!/tuiachartcenter/tuiatableview/330/${record.slotId}/${record.curDate}`;
        return (
          <a target="_blank" href={href}>
            <p>{ record.slotId }</p>
            <p>{ record.slotName }</p>
          </a>
        );
      }
    }, {
      title: '媒体id',
      dataIndex: 'appId',
      key: 'appId',
      fixed: 'left',
      width: 100,
      render: (text, record, index) => {
        return (
          <div>
            <p>{ record.appId }</p>
            <p>{ record.appName }</p>
          </div>
        );
      }
    }, {
      title: '运营',
      dataIndex: 'mediaName',
      key: 'mediaName',
      render: (text, record, index) => {
        return (
          <div>
            <p> 媒体运营：{ record.mediaName }</p>
            <p> 媒介运营：{ record.agentName }</p>
          </div>
        );
      }
    }, {
      title: '处理状态',
      dataIndex: 'exampleStatus',
      key: 'exampleStatus',
      render: (text, record, index) => {
        return (
          tableHoc('exampleStatus', {exampleStatus: record.exampleStatus, id: record.id})(
            <Select
              placeholder="处理状态"
              defaultValue={text}
            >
              {statusArr && statusArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
            </Select>
          )
        );
      }
    }, {
      title: '综合信用分',
      dataIndex: 'creditsScore',
      key: 'creditsScore',
      render: (text, record, index) => {
        return text || '-';
      }
    }, {
      title: '处理人',
      dataIndex: 'preRiskReviewer',
      key: 'preRiskReviewer',
      render: (text, record, index) => {
        return record.preRiskReviewer || record.riskReviewer;
      }
    }, {
      title: '作弊消耗',
      dataIndex: 'cheatFee',
      key: 'cheatFee',
      render: (text, record, index) => {
        return formatNum('100', text);
      }
    }, {
      title: '作弊消耗占比',
      dataIndex: 'cheatFeeRate',
      key: 'cheatFeeRate',
      render: (text, record, index) => {
        return formatNum('%', text);
      }
    }, {
      title: '广告位消耗',
      dataIndex: 'adConsume',
      key: 'adConsume',
      render: (text, record, index) => {
        return formatNum('100', text);
      }
    }, {
      title: '分成比例',
      dataIndex: 'divideRate',
      key: 'divideRate',
      render: (text, record, index) => {
        return formatNum('%', text);
      }
    }, {
      title: '命中规则',
      dataIndex: 'rules',
      key: 'rules',
      render: (text, record, index) => {
        let href = '';
        if (record.dHour === '1') href = `http://eye.dui88.com/tuia#!/tuiachartcenter/tuiatableview/118/${record.slotId}/${record.curDate}`;
        if (record.dHour !== '' && record.dHour !== '1') href = `http://eye.dui88.com/tuia#!/tuiachartcenter/tuiatableview/329/${record.slotId}/${record.curDate}`;
        return <a target="_blank" href={href}>{text}</a>;
      }
    }, {
      title: '累计处理次数',
      dataIndex: 'reviewCount',
      key: 'reviewCount',
      render: (text, record, index) => {
        const { updateReviewResultModalObj } = store;
        const showReviewResultModal = () => {
          updateReviewResultModalObj({record: record, show: true});
        };
        return <a onClick={showReviewResultModal}>{text}</a>;
      }
    }, {
      title: '案例特征',
      dataIndex: 'exampleFeatures',
      key: 'exampleFeatures',
      width: 200,
      render: (text, record, index) => {
        return textAreahoc('exampleFeatures', { exampleFeatures: record.exampleFeatures, id: record.id }, Object.assign({}, record, {tableTitle: '案例特征'}))(
          <span className={styles.limit}>{text}</span>
        );
      }
    }, {
      title: '案例需求',
      dataIndex: 'exampleDemand',
      key: 'exampleDemand',
      width: 200,
      render: (text, record, index) => {
        return textAreahoc('exampleDemand', { exampleDemand: record.exampleDemand, id: record.id }, Object.assign({}, record, {tableTitle: '案例需求'}))(
          <span className={styles.limit}>{text}</span>
        );
      }
    }, {
      title: '案例结果',
      dataIndex: 'exampleResult',
      key: 'exampleResult',
      width: 200,
      render: (text, record, index) => {
        return textAreahoc('exampleResult', { exampleResult: record.exampleResult, id: record.id }, Object.assign({}, record, {tableTitle: '案例结果'}))(
          <span className={styles.limit}>{text}</span>
        );
      }
    }, {
      title: '图片附件',
      key: 'imgs',
      render: (text, record, index) => {
        return imgView('imgs', { imgs: record.imgs, id: record.id }, Object.assign({}, record, {tableTitle: '图片附件'}))(
          <div>{text}</div>
        );
      }
    }, {
      title: '操作',
      key: 'operates',
      render: (text, record, index) => (
        <div>
          <a className={styles.link} onClick= {() => this.handleEditBtn(record)}>编辑</a>
          <a className={styles.link} onClick= {() => this.delCase(record.id)}>删除</a>
        </div>
      )
    }
    ];
    // 分页配置信息
    const paganationOpts = {
      defaultPageSize: 6,
      current: store.params.currentPage,
      total: dataList.totalCount,
      showTotal: (total) => { return `共${total}条`; },
      onChange: page => {
        const { getDataList, updateParams } = store;
        updateParams({currentPage: page});
        getDataList();
      }
    };
    const { downLoadTable } = store;
    return (
      <div>
        <Button type="primary" htmlType="submit" onClick={this.handleAddBtn} >添加</Button>
        <Icon type="download" className={styles.down} onClick={downLoadTable}/>
        <Table
          className="tableStyle"
          scroll={{ x: 2900 }}
          rowKey="id"
          columns={columns}
          dataSource={_dataSource}
          pagination={true}
          pagination={paganationOpts}
          loading={dataIsLoading}
          locale={{ emptyText: '暂无数据' }}
        />
        <AddAndEditModal addCaseModalObj={addCaseModalObj}/>
        {reviewResultModalObj.show ? <ReviewResultModal reviewResultModalObj={reviewResultModalObj}/> : null }
      </div>
    );
  }
}

export default AuditCaseTable;
