import React from 'react';
import { observer } from 'mobx-react';
import store from '../store';
import styles from './index.less';

import {
  DatePicker,
  Form,
  Input,
  Button
} from 'antd';
const FormItem = Form.Item;
const RangePicker = DatePicker.RangePicker;
const dateFormat = 'YYYY-MM-DD';

@observer
class SearchFilter extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false
    };
  }
  componentDidMount() {
    this.search();
  }

  // 查询
  search = () => {
    this.props.form.validateFields((errors, values) => {
      if (!!errors) {
        return;
      }
      const { updateParams, getDataList } = store;
      let timeRange = values.time || [];
      let params = {
        startTime: (timeRange[0] && timeRange[0].format(dateFormat)) || '',
        endTime: (timeRange[1] && timeRange[1].format(dateFormat)) || '',
        slotId: values.slotId || '',
        appId: values.appId || '',
        currentPage: 1
      };
      updateParams(params);
      getDataList();
    });
  }

  updateTime = (times) => {
    const startTime = times[0];
    const endTime = times[1];
    store.updateParams({startTime, endTime});
  }

  render() {
    const { getFieldDecorator } = this.props.form;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 16 }
      }
    };
    let slotIdProps = getFieldDecorator('slotId');
    let appIdProps = getFieldDecorator('appId');
    // 日期选择器
    let timeProps = getFieldDecorator('time', {
    });
    return (
      <div className={styles.search_warp}>
        <Form layout="inline" >
          <FormItem>
            {timeProps(
              <RangePicker
                className={styles.search}
                showTime
                format={dateFormat}
                placeholder={['Start Time', 'End Time']}
              />
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="广告位id"
          >
            {slotIdProps(
              <Input type="text" />
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="媒体id"
          >
            {appIdProps(
              <Input type="text" />
            )}
          </FormItem>
          <FormItem>
            <Button
              type="primary"
              htmlType="submit"
              onClick={this.search}
            >
              查询
            </Button>
          </FormItem>

        </Form>
      </div>
    );
  }
}

const PageSearch = Form.create({})(SearchFilter);
export default PageSearch;
