import React from 'react';
import { Table, Button } from 'antd';
import { observer } from 'mobx-react';
import store from '../store';

import EditModal from '../modals/editModal';
import styles from './index.less';

@observer
class ScenceTable extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      // 储存当前选中的行
      selectedRows: [],
      editObj: [],
      isEdit: false,
      show: false
    };
  }
  showModal = (isEdit, obj) => {
    this.setState({
      isEdit: isEdit,
      show: true,
      editObj: obj
    });
  }
  closeModal = () => {
    this.setState({
      show: false
    });
  }
  render() {
    const columns = [{
      title: '场景名称',
      dataIndex: 'sceneName',
      key: 'sceneName',
      width: 150
    }, {
      title: '场景标识',
      dataIndex: 'sceneKey',
      key: 'sceneKey',
      width: 150
    }, {
      title: '场景类型',
      dataIndex: 'sceneType',
      key: 'sceneType',
      width: 150,
      render: (text, record, index) => {
        const sceneType = text === 0 ? '实时场景' : '准实时场景';
        return sceneType || '-';
      }
    }, {
      title: '描述',
      dataIndex: 'description',
      key: 'description',
      width: 150
    }, {
      title: '创建人',
      dataIndex: 'creator',
      key: 'creator',
      width: 150,
      render: (text, record, index) => {
        return text || '-';
      }
    }, {
      title: '更新时间',
      dataIndex: 'gmtModifiedView',
      key: 'gmtModifiedView',
      width: 150
    }, {
      title: '操作',
      key: 'operates',
      width: 150,
      render: (text, record, index) => {
        const { checkStrategy } = store;
        return (
          <div>
            <a className={styles.link} onClick= {(e) => { this.showModal(true, record); }}>编辑</a>
            <a className={styles.link} onClick= {() => checkStrategy(record.id)}>删除</a>
          </div>

        );
      }
    }];
    const { dataIsLoading, dataList } = store;
    let _dataSource = dataList.list ? dataList.list.slice() : [];
    const paganationOpts = {
      defaultPageSize: 10,
      current: store.params.currentPage,
      total: dataList.totalCount,
      showTotal: (total) => { return `共${total}条`; },
      onChange: page => {
        const { getDataList, updateParams } = store;
        updateParams({currentPage: page});
        getDataList();
      }
    };
    return (
      <div>
        <Button className={styles.newBotton} type="primary" htmlType="submit" onClick={() => this.showModal(false, {})}>新建场景</Button>
        <Table
          // scroll={{ x: 2900 }}
          scroll={{ y: 500 }}
          rowKey="id"
          columns={columns}
          dataSource={_dataSource}
          pagination={true}
          pagination={paganationOpts}
          loading={dataIsLoading}
          locale={{ emptyText: '暂无数据' }}
        />
        {this.state.show ? <EditModal editObj={this.state.editObj} isEdit={this.state.isEdit} closeModal={this.closeModal}/> : null}
      </div>
    );
  }
}

export default ScenceTable;
