import { observable, action } from 'mobx';
import common from 'src/lib/common';
import utils from 'src/lib/utils';
import { message } from 'antd';

class State {
  @observable
  dataIsLoading = false;
  // 请求参数
  @observable
  params = {
    pageSize: 10,
    ruleName: '',
    strategyId: '',
    currentPage: 1
  };
  // 更新params
  @action
  updateParams = (params) => {
    this.params = Object.assign({}, this.params, params);
  }
  // table数据
  @observable
  dataList = {
    list: []
  };
  // 获取table数据
  @action
  getDataList = () => {
    this.dataIsLoading = true;
    let strategyId = utils.getURLParameter('strategyId');
    let params = Object.assign({}, this.params);
    params.strategyId = strategyId;
    common.fetch('/rules', params, 'get')
      .then(res => {
        this.dataIsLoading = false;
        this.dataList = res.data || ({
          list: []
        });
      });
  }
  // 字段数据
  @observable
  fieldArr = [];
  // 获取字段数据
  @action
  getFieldList = () => {
    let sceneId = utils.getURLParameter('sceneId');
    common.fetch('/engineField/getFieldBySceneId', {sceneId: sceneId}, 'get')
      .then(res => {
        this.fieldArr = res.data;
      });
  }
  // 规则名称在同一策略下是否重复
  @action
  checkRuleName = (params, isEdit) => {
    let strategyId = utils.getURLParameter('strategyId');
    params.strategyId = strategyId;
    let params1 = {
      ruleName: params.name,
      strategyId: strategyId,
      ruleId: params.id
    };
    return new Promise((resolve) => {
      common.fetch('/rules/exist', params1, 'get')
        .then(res => {
          if (res.data === false) {
            resolve(res);
            isEdit ? this.updateRuleList(params) : this.addRuleList(params);
          } else {
            message.warning('规则名已存在！');
          }
        });
    });
  }
  // 添加规则
  @action
  addRuleList = (params) => {
    let strategyId = utils.getURLParameter('strategyId');
    params.strategyId = strategyId;
    common.fetch('/rules', params, 'post', {isJson: true})
      .then(res => {
        this.getDataList();
      });
  }
  // 编辑规则
  @action
  updateRuleList = (params) => {
    let strategyId = utils.getURLParameter('strategyId');
    params.strategyId = strategyId;
    common.fetch('/rules', params, 'put', {isJson: true})
      .then(res => {
        this.getDataList();
      });
  }
  // 更新状态
  @action
  updateStatus = (params) => {
    common.fetch(`/rules/${params.id}/${params.status}`, params, 'put', {isJson: false})
      .then(res => {
        this.getDataList();
      });
  }
  // 删除规则
  @action
  deleteRule = (id) => {
    common.fetch(`/rules/${id}`, {id: id}, 'delete', {isJson: true})
      .then(res => {
        common.handleSuccess('删除成功！');
        this.getDataList();
      });
  }
  // 新增/编辑表单ref
  @observable
  formRef = {};
  // 保存新增编辑表单ref
  @action
  saveFormRef = (formRef) => {
    this.formRef = formRef;
  }
}

const store = new State();
export default store;
