import React from 'react';
import { observer } from 'mobx-react';
import styles from './index.less';
import store from '../store';

import {
  Form,
  Input,
  Button
} from 'antd';
const FormItem = Form.Item;

@observer
class SearchFilter extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false
    };
  }
  componentDidMount() {
    const { getAllScence } = store;
    this.search();
    getAllScence();
  }

  // 查询
  search = () => {
    this.props.form.validateFields((errors, values) => {
      if (!!errors) {
        return;
      }
      const { updateParams, getDataList } = store;
      let params = {
        name: values.name || '',
        currentPage: 1
      };
      updateParams(params);
      getDataList();
    });
  }

  render() {
    const { getFieldDecorator } = this.props.form;
    let nameProps = getFieldDecorator('name');
    return (
      <div className={styles.search_warp}>
        <Form layout="inline" >
          <FormItem
            label="字段名称"
          >
            {nameProps(
              <Input type="text" />
            )}
          </FormItem>
          <FormItem>
            <Button
              type="primary"
              htmlType="submit"
              onClick={this.search}
            >
              查询
            </Button>
          </FormItem>

        </Form>
      </div>
    );
  }
}

const PageSearch = Form.create({})(SearchFilter);
export default PageSearch;
