import React from 'react';
import { observer } from 'mobx-react';
import store from '../store';
import styles from './index.less';

import {
  DatePicker,
  Form,
  Input,
  Button,
  Select
} from 'antd';
import moment from 'moment';
const FormItem = Form.Item;
const Option = Select.Option;
const { RangePicker } = DatePicker;
const dateFormat = 'YYYY-MM-DD';
const dimension = [
  { value: '', text: '全部' },
  { value: 0, text: 'ip' },
  { value: 1, text: 'device_id' },
  { value: 2, text: 'consumer_id' }
];
const stat = [
  { value: '', text: '全部' },
  { value: 0, text: '启用' },
  { value: 1, text: '禁用' }
];
@observer
class SearchFilter extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false,
      time: [moment().subtract(30, 'days'), moment().subtract(0, 'days')]
    };
  }
  componentDidMount() {
    this.search();
  }
  // 查询
  search = () => {
    const { updateParams, getDataList } = store;
    const { getFieldValue } = this.props.form;
    let timeRange = getFieldValue('time');
    let params = {
      'dateRange.from': (timeRange && timeRange[0] && timeRange[0].format(dateFormat)) || '',
      'dateRange.to': (timeRange && timeRange[1] && timeRange[1].format(dateFormat)) || '',
      dimension: getFieldValue('dimension'),
      stat: getFieldValue('stat'),
      src: getFieldValue('src') || '',
      currentPage: 1
    };
    updateParams(params);
    getDataList();
  }
  // 重置
  reset = () => {
    const { resetFields } = this.props.form;
    resetFields();
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 16 }
      }
    };
    // 名单维度
    let dimensionProps = getFieldDecorator('dimension', {
      initialValue: ''
    });
    // 状态
    let statProps = getFieldDecorator('stat', {
      initialValue: 0
    });
    // 来源
    let srcProps = getFieldDecorator('src');
    // 日期选择器
    let timeProps = getFieldDecorator('time', {
      initialValue: this.state.time
    });
    return (
      <div className={styles.search_warp}>
        <Form layout="inline" >
          <FormItem>
            {timeProps(
              <RangePicker
                format={dateFormat}
              />
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="名单维度"
          >
            {
              dimensionProps(
                <Select
                  style={{ width: '140px' }}
                  placeholder="Tags Mode"
                >
                  {dimension && dimension.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
                </Select>
              )
            }
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="状态"
          >
            {
              statProps(
                <Select
                  style={{ width: '80px' }}
                  placeholder="Tags Mode"
                >
                  {stat && stat.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
                </Select>
              )
            }
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="来源"
          >
            {srcProps(
              <Input type="text" />
            )}
          </FormItem>
          <FormItem>
            <Button
              type="primary"
              htmlType="submit"
              onClick={this.search}
            >
              查询
            </Button>
          </FormItem>
          <FormItem>
            <Button
              type="primary"
              htmlType="submit"
              onClick={this.reset}
            >
              重置
            </Button>
          </FormItem>

        </Form>
      </div>
    );
  }
}

const PageSearch = Form.create({})(SearchFilter);
export default PageSearch;
