module.exports = {
  path: 'ruleEngine',
  getComponent(nextState, cb) {
    require.ensure([], (require) => {
      cb(null, require('src/containers/ruleEngine').default);
    });
  },
  childRoutes: [{
    path: 'scence',
    breadcrumbName: '场景管理',
    getComponent(location, cb) {
      require.ensure([], require => {
        cb(null, require('src/containers/ruleEngine/scence').default);
      });
    }
  },
  {
    path: 'strategy',
    breadcrumbName: '策略管理',
    getComponent(location, cb) {
      require.ensure([], require => {
        cb(null, require('src/containers/ruleEngine/strategy').default);
      });
    },
    childRoutes: [{
      path: 'rule',
      breadcrumbName: '规则管理',
      getComponent(location, cb) {
        require.ensure([], require => {
          cb(null, require('src/containers/ruleEngine/rule').default);
        });
      }
    }]
  },
  // {
  //   path: 'rule',
  //   breadcrumbName: '规则管理',
  //   getComponent(location, cb) {
  //     require.ensure([], require => {
  //       cb(null, require('src/containers/ruleEngine/rule').default);
  //     });
  //   }
  // },
  {
    path: 'report',
    breadcrumbName: '风控报告',
    getComponent(location, cb) {
      require.ensure([], require => {
        cb(null, require('src/containers/ruleEngine/report').default);
      });
    }
  },
  {
    path: 'field',
    breadcrumbName: '字段管理',
    getComponent(location, cb) {
      require.ensure([], require => {
        cb(null, require('src/containers/ruleEngine/field').default);
      });
    }
  }]
};
