import React from 'react';
import { Table, Dropdown, Button, Modal, Menu, Icon } from 'antd';
import { observer } from 'mobx-react';
import EditModal from '../modals/editModal';

import moment from 'moment';
import store from '../store';
import styles from './index.less';

const confirm = Modal.confirm;

@observer
class StrategyTable extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedRows: [],
      editObj: [],
      isEdit: false,
      show: false
    };
  }
  showModal = (isEdit, obj) => {
    this.setState({
      isEdit: isEdit,
      show: true,
      editObj: obj
    });
  }
  closeModal = () => {
    this.setState({
      show: false
    });
  }
  changeStatus(record, status) {
    const { saveStrategyList } = store;
    confirm({
      title: '提示',
      content: '确认修改?',
      okText: '确定',
      okType: 'danger',
      cancelText: '取消',
      onOk() {
        let params = {
          description: record.description,
          sceneId: record.sceneId,
          score1: record.score1,
          score2: record.score2,
          score3: record.score3,
          score4: record.score4,
          strategyKey: record.strategyKey,
          strategyName: record.strategyName,
          strategyType: record.strategyType,
          status: parseInt(status)
        };
        saveStrategyList(params);
      },
      onCancel() {
        console.log('you chose close!');
      }
    });
  }
  render() {
    const columns = [{
      title: '策略名称',
      dataIndex: 'strategyName',
      key: 'strategyName',
      width: 150,
      render: (text, record, index) => {
        return (
          <a href={`#/ruleEngine/strategy/rule?strategyId=${record.id}&sceneId=${record.sceneId}`}>
            <p>{ text }</p>
          </a>
        );
      }
    }, {
      title: '策略标识',
      dataIndex: 'strategyKey',
      key: 'strategyKey',
      width: 150
    }, {
      title: '关联场景',
      dataIndex: 'sceneName',
      key: 'sceneName',
      width: 150,
      render: (text, record, index) => {
        return text || '-';
      }
    }, {
      title: '状态',
      dataIndex: 'status',
      key: 'status',
      width: 100,
      render: (text, record, index) => {
        const status = text === 1 ? '启用' : '禁用';
        return status || '-';
      }
    }, {
      title: '描述',
      dataIndex: 'description',
      key: 'description',
      width: 150,
      render: (text, record, index) => {
        return text || '-';
      }
    }, {
      title: '最近更新人',
      dataIndex: 'editor',
      key: 'editor',
      width: 100
    }, {
      title: '更新时间',
      dataIndex: 'gmtModified',
      key: 'gmtModified',
      width: 150,
      render: (text, record, index) => {
        const updateTime = moment(text).format('YYYY-MM-DD HH:mm:ss');
        return updateTime || '-';
      }
    }, {
      title: '操作',
      key: 'operates',
      width: 150,
      render: (text, record, index) => {
        const statusMenu = (
          <Menu onClick={(e) => { this.changeStatus(record, e.key); }}>
            <Menu.Item key="1">启用</Menu.Item>
            <Menu.Item key="0">禁用</Menu.Item>
          </Menu>
        );
        const { checkIsRule } = store;
        return (
          <div>
            <Dropdown overlay={statusMenu} trigger={['click']}>
              <a className={styles.link}>
                状态 <Icon type="down" />
              </a>
            </Dropdown>
            <a className={styles.link} onClick= {(e) => { this.showModal(true, record); }}>编辑</a>
            <a className={styles.link} onClick= {() => checkIsRule(record.strategyKey)}>删除</a>
          </div>
        );
      }
    }];
    const { dataIsLoading, dataList } = store;
    let _dataSource = dataList.list ? dataList.list.slice() : [];
    const paganationOpts = {
      defaultPageSize: 10,
      current: store.params.currentPage,
      total: dataList.totalCount,
      showTotal: (total) => { return `共${total}条`; },
      onChange: page => {
        const { getDataList, updateParams } = store;
        updateParams({currentPage: page});
        getDataList();
      }
    };
    return (
      <div>
        <Button className={styles.newBotton} type="primary" htmlType="submit" onClick={() => this.showModal(false, {})}>新建策略</Button>
        <Table
          // scroll={{ x: 2900 }}
          scroll={{ y: 500 }}
          rowKey="id"
          columns={columns}
          dataSource={_dataSource}
          pagination={true}
          pagination={paganationOpts}
          loading={dataIsLoading}
          locale={{ emptyText: '暂无数据' }}
        />
        {this.state.show ? <EditModal editObj={this.state.editObj} isEdit={this.state.isEdit} closeModal={this.closeModal}/> : null}
      </div>
    );
  }
}

export default StrategyTable;
