import React from 'react';
import { observer } from 'mobx-react';
import styles from './index.less';
import store from '../store';

import {
  Form,
  Button,
  Select
} from 'antd';
const FormItem = Form.Item;
const Option = Select.Option;

@observer
class SearchFilter extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false
    };
  }
  componentDidMount() {
    const { getAllScence } = store;
    this.search();
    getAllScence();
  }

  // 查询
  // 查询
  search = () => {
    const { updateParams, getDataList } = store;
    const { getFieldValue } = this.props.form;
    let params = {
      sceneId: getFieldValue('sceneId'),
      currentPage: 1
    };
    updateParams(params);
    getDataList();
  }

  render() {
    const { getFieldDecorator } = this.props.form;
    const { sceneIdsArr } = store;
    let arr = sceneIdsArr.slice();
    arr.unshift({id: null, sceneName: '全部'});
    // 场景类型
    let sceneIdProps = getFieldDecorator('sceneId', {
      initialValue: null
    });
    return (
      <div className={styles.search_warp}>
        <Form layout="inline" >
          <FormItem
            label="场景"
          >
            {sceneIdProps(
              <Select
                style={{ width: '120px' }}
                placeholder="请选择"
              >
                {arr && arr.map((d, index) => <Option key={index} value={d.id}>{d.sceneName}</Option>)}
              </Select>
            )}
          </FormItem>
          <FormItem>
            <Button
              type="primary"
              htmlType="submit"
              onClick={this.search}
            >
              查询
            </Button>
          </FormItem>

        </Form>
      </div>
    );
  }
}

const PageSearch = Form.create({})(SearchFilter);
export default PageSearch;
