import { observable, action } from 'mobx';
import common from 'src/lib/common';
import { Modal, message } from 'antd';

const confirm = Modal.confirm;

class State {
  @observable
  dataIsLoading = false;
  // 请求参数
  @observable
  params = {
    pageSize: 10,
    sceneName: '',
    currentPage: 1
  };
  // 更新params
  @action
  updateParams = (params) => {
    this.params = Object.assign({}, this.params, params);
  }
  // table数据
  @observable
  dataList = {
    list: []
  };
  // 获取table数据
  @action
  getDataList = () => {
    this.dataIsLoading = true;
    let params = Object.assign({}, this.params);
    common.fetch('/engineScene/queryPage', params, 'get')
      .then(res => {
        this.dataIsLoading = false;
        this.dataList = res.data || ({
          list: []
        });
      });
  }
  // 场景名称重复判断
  @action
  checkSceneName = (params, isEdit) => {
    const name = params.sceneName;
    const id = params.id ? params.id : '';
    return new Promise((resolve) => {
      common.fetch('/engineScene/checkSceneKeyOrName', {sceneName: name, id: id}, 'get')
        .then(res => {
          if (res.data === false) {
            isEdit ? (resolve(res) || this.updateScenceList(params)) : this.checkSceneKey(params, isEdit).then(resolve);
          } else {
            message.warning('场景名称已存在!');
          }
        });
    });
  }
  // 场景标识重复判断
  @action
  checkSceneKey = (params, isEdit) => {
    const key = params.sceneKey;
    return new Promise(resolve => {
      common.fetch('/engineScene/checkSceneKeyOrName', {sceneKey: key}, 'get')
        .then(res => {
          if (res.data === false) {
            resolve();
            this.addScenceList(params);
          } else {
            message.warning('场景标识已存在!');
          }
        });
    });
  }
  // 添加场景
  @action
  addScenceList = (params) => {
    common.fetch('/engineScene/add', params, 'post', {isJson: true})
      .then(res => {
        this.getDataList();
      });
  }
  // 更新场景
  @action
  updateScenceList = (params) => {
    common.fetch('/engineScene/update', params, 'post', {isJson: true})
      .then(res => {
        this.getDataList();
      });
  }
  // 删除场景
  @action
  deleteScence = (id) => {
    common.fetch('/engineScene/delete', {id: id}, 'post', {isJson: true})
      .then(res => {
        common.handleSuccess('删除成功！');
        this.getDataList();
      });
  }
  // 校验该场景下有无关联策略
  @action
  checkStrategy = (id) => {
    common.fetch('/engineScene/checkStrategy', {id: id}, 'get')
      .then(res => {
        if (res.data === false) {
          this.checkField(id);
          // confirm({
          //   title: '提示',
          //   content: '确认修改?',
          //   okText: '确定',
          //   okType: 'danger',
          //   cancelText: '取消',
          //   onOk: () => {
          //     this.deleteScence(id);
          //   },
          //   onCancel() {
          //     console.log('you chose close!');
          //   }
          // });
        } else {
          message.warning('场景下已关联策略，无法删除!');
        }
      });
  }
  // 校验该场景下有无关联字段
  @action
  checkField = (id) => {
    common.fetch('/engineScene/checkField', {id: id}, 'get')
      .then(res => {
        if (res.data === false) {
          confirm({
            title: '提示',
            content: '确认删除?',
            okText: '确定',
            okType: 'danger',
            cancelText: '取消',
            onOk: () => {
              this.deleteScence(id);
            },
            onCancel() {
              console.log('you chose close!');
            }
          });
        } else {
          message.warning('场景下已关联字段，无法删除!');
        }
      });
  }
}

const store = new State();
export default store;
