import React from 'react';
import { Table, Dropdown, Button, Modal, Icon, Menu } from 'antd';
import { observer } from 'mobx-react';
import EditModal from '../modals/editModal';

import store from '../store';
import styles from './index.less';

const confirm = Modal.confirm;

@observer
class RuleTable extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      editObj: [],
      isEdit: false,
      show: false,
      type: 0
    };
  }
  showModal = (isEdit, obj, type) => {
    this.setState({
      isEdit: isEdit,
      show: true,
      editObj: obj,
      type: type
    });
  }
  closeModal = () => {
    this.setState({
      show: false
    });
  }
  delCase = (id) => {
    const { deleteRule } = store;
    confirm({
      title: '提示',
      content: '确认删除?',
      okText: '确定',
      okType: 'danger',
      cancelText: '取消',
      onOk() {
        deleteRule(id);
      },
      onCancel() {
        console.log('you chose close!');
      }
    });
  }
  changeStatus(id, status) {
    const { updateStatus } = store;
    confirm({
      title: '提示',
      content: '确认修改?',
      okText: '确定',
      okType: 'danger',
      cancelText: '取消',
      onOk() {
        let params = {
          id: id,
          status: status
        };
        updateStatus(params);
      },
      onCancel() {
        console.log('you chose close!');
      }
    });
  }
  render() {
    const columns = [{
      title: '规则名称',
      dataIndex: 'name',
      key: 'name',
      width: 150,
      render: (text, record, index) => {
        const isIndent = record.parentRuleId ? <span className={styles.indent}>{text}</span> : text;
        return isIndent;
      }
    }, {
      title: '备注',
      dataIndex: 'description',
      key: 'description',
      width: 150
    }, {
      title: '状态',
      dataIndex: 'status',
      key: 'status',
      width: 150,
      render: (text, record, index) => {
        const status = text === 0 ? '启用' : text === 1 ? '禁用' : '试运行';
        return status;
      }
    }, {
      title: '操作',
      key: 'operates',
      width: 150,
      render: (text, record, index) => {
        const statusMenu = (
          <Menu onClick= {(e) => { this.changeStatus(record.id, e.key); }}>
            <Menu.Item key="0">启用</Menu.Item>
            <Menu.Item key="1">禁用</Menu.Item>
            <Menu.Item key="2">试运行</Menu.Item>
          </Menu>
        );
        return (
          <div>
            {record.type === 0 && record.parentRuleId === null ? <a className={styles.link} onClick= {(e) => { this.showModal(false, {}, record.type); }}>+子规则</a> : <span className={styles.empty}></span>}
            <Dropdown overlay={statusMenu} trigger={['click']}>
              <a className={styles.link}>
                状态 <Icon type="down" />
              </a>
            </Dropdown>
            <a className={styles.link} onClick= {(e) => { this.showModal(true, record, record.type.toString()); }}>编辑</a>
            <a className={styles.link} onClick= {() => this.delCase(record.id)}>删除</a>
          </div>
        );
      }
    }];
    const { dataIsLoading, dataList } = store;
    let _dataSource = dataList.list ? dataList.list.slice() : [];
    const paganationOpts = {
      defaultPageSize: 10,
      current: store.params.currentPage,
      total: dataList.totalCount,
      showTotal: (total) => { return `共${total}条`; },
      onChange: page => {
        const { getDataList, updateParams } = store;
        updateParams({currentPage: page});
        getDataList();
      }
    };
    const menu = (
      <Menu onClick= {(e) => { this.showModal(false, {}, e.key); }}>
        <Menu.Item key="0">流程规则</Menu.Item>
        <Menu.Item key="1">评分规则</Menu.Item>
      </Menu>
    );
    return (
      <div>
        <Dropdown className={styles.newBotton} overlay={menu} trigger={['click']}>
          <Button style={{ marginLeft: 8 }}>
            新建规则 <Icon type="down" />
          </Button>
        </Dropdown>
        <Table
          // scroll={{ x: 2900 }}
          scroll={{ y: 500 }}
          rowKey="id"
          columns={columns}
          dataSource={_dataSource}
          pagination={true}
          pagination={paganationOpts}
          loading={dataIsLoading}
          locale={{ emptyText: '暂无数据' }}
        />
        {this.state.show ? <EditModal editObj={this.state.editObj} isEdit={this.state.isEdit} type={this.state.type} closeModal={this.closeModal}/> : null}
      </div>
    );
  }
}

export default RuleTable;
