import React from 'react';
import { Table } from 'antd';

class ReportTable extends React.Component {
  constructor(props) {
    super(props);
    this.state = {};
  }
  render() {
    const columns = [{
      title: '订单号',
      dataIndex: 'gmtCreate'
    }, {
      title: '场景',
      dataIndex: 'curDate'
    }, {
      title: '用户ID',
      dataIndex: 'appId'
    }, {
      title: '设备ID',
      dataIndex: 'creditsScore',
      render: (text, record, index) => {
        return text || '-';
      }
    }, {
      title: 'IP地址',
      dataIndex: 'preRiskReviewer',
      render: (text, record, index) => {
        return record.preRiskReviewer || record.riskReviewer;
      }
    }, {
      title: '审核结果'
    }, {
      title: '审批时间'
    }];
    let _dataSource;
    const paganationOpts = {};
    return (
      <div>
        <Table
          // scroll={{ x: 2900 }}
          rowKey="id"
          columns={columns}
          dataSource={_dataSource}
          pagination={true}
          pagination={paganationOpts}
          // loading={dataIsLoading}
          locale={{ emptyText: '暂无数据' }}
        />
      </div>
    );
  }
}

export default ReportTable;
