import { observable, action } from 'mobx';
import common from 'src/lib/common';
class State {
  @observable
  fileArr = [];
  @observable
  dataIsLoading = false;
  // 请求参数
  @observable
  params = {
    startTime: '',
    endTime: '',
    slotId: '',
    appId: '',
    pageSize: 6,
    currentPage: 1
  };
  @observable
  showAddAndEditModal = false;
  @observable
  record = {};
  // 新增编辑表单ref
  @observable
  formRef = {};
  // 更新params
  @action
  updateParams = (params) => {
    this.params = Object.assign({}, this.params, params);
  }
  // table数据
  @observable
  dataList = {
    list: []
  };
  // 获取table数据
  @action
  getDataList = () => {
    this.dataIsLoading = true;
    let params = Object.assign({}, this.params);
    params.startTime = params.startTime;
    params.endTime = params.endTime;
    common.fetch('riskExample/queryPage', params, 'get')
      .then(res => {
        this.dataIsLoading = false;
        this.dataList = res.data || ({
          list: []
        });
      });
  }
  // 删除案例
  @action
  delCase = (id) => {
    common.fetch('riskExample/deleExample', {id: id}, 'post', {isJson: true})
      .then(res => {
        common.handleSuccess('删除成功！');
        this.getDataList();
      });
  }
  // 更新添加操作
  @action
  addOrUpdate = (params) => {
    common.fetch('/riskExample/addOrUpdate', params, 'post', {isJson: true})
      .then(res => {
        common.handleSuccess('修改成功！');
        this.getDataList();
      });
  }
  // 更新图片
  @action
  updatePhoto= (fileArr = []) => {
    this.fileArr = fileArr;
  }
  // 获得图片
  @action
  getPhoto = (id) => {
    common.fetch(`/riskExample/${id}`, {}, 'get')
      .then(res => {
        this.fileArr = res.data || [];
      });
  }
  // 保存图片
  @action
  savePhoto = (params) => {
    common.fetch('/riskExample/imgs', params, 'post', {isJson: true})
      .then(res => {
        if (res.data === false) {
          common.handleSuccess('添加成功!');
          this.showAddPhotoModalObj({show: false});
        } else if (res.code === '0100008') {
          common.handleWarn('案例图片最多为四张!');
        }
        this.getDataList();
      });
  }
  // 删除图片
  @action
  deletePhoto = (id) => {
    const promise = new Promise((resolve, reject) => {
      common.fetch(`/riskExample/img/${id}`, {}, 'delete', {isJson: false})
        .then(res => {
          resolve(res);
          common.handleSuccess('删除成功！');
        });
    });
    return promise;
  }
  // addCaseModal 添加案例弹框
  @observable
  addCaseModalObj = {
    show: false,
    record: {}
  }
  // 更新addCaseModal状态
  @action
  updateAddCaseModalObj = (arg) => {
    this.addCaseModalObj = Object.assign({}, this.addCaseModalObj, arg);
  }
  // 保持addCaseModal状态
  @action
  addCase = (params) => {
    this.addCaseModalObj.show = false;
    common.fetch('riskExample/addOrUpdate', params, 'post', {isJson: true})
      .then(res => {
        this.getDataList();
      });
  }
  // addPhotoModal 添加案例弹框
  @observable
  addPhotoModalObj = {
    show: false,
    record: {},
    title: ''
  }
  // 判断是否有未保存的内容
  @observable
  hasContentChanged = false;
  // 修改内容修改状态
  @action
  setContentChanged = (status) => {
    this.hasContentChanged = status;
  }
  // 更新addPhotoModal状态
  @action
  showAddPhotoModalObj = (arg) => {
    this.addPhotoModalObj = Object.assign({}, this.addPhotoModalObj, arg);
  }
  // 保存添加编辑弹窗form数据
  @action
  saveStickItem = (data) => {
    common.fetch('riskExample/addOrUpdate', data, 'post', {isJson: true})
      .then(res => {
        this.getDataList();
      });
  }
  // 保持addPhotoModal状态
  @action
  getaddPhotoModal = (params) => {
    this.addPhotoModalObj.show = false;
    common.fetch('riskExample/addOrUpdate', params, 'post', {isJson: true})
      .then(res => {
        this.getDataList();
      });
  }
  // 处理结果弹框
  @observable
  reviewResultModalObj = {
    show: false,
    record: {},
    list: [],
    totalCount: 0,
    currentPage: 1
  }
  // 更新reviewResultModal状态
  @action
  updateReviewResultModalObj = (arg) => {
    this.reviewResultModalObj = Object.assign({}, this.reviewResultModalObj, arg);
  }
  // 保持reviewResultModal状态
  @action
  getReviewResultModal = (params) => {
    common.fetch('/riskReview/handleRecord', params, 'get')
      .then(res => {
        this.reviewResultModalObj.list = res.data.list;
        this.reviewResultModalObj.totalCount = res.data.totalCount;
      });
  }
  // 弹框导出
  @action
  downReviewResultTable = (params) => {
    window.open('/riskReview/exportHandleRecords?' + common.concatUrl(params));
  }
  // 导出
  @action
  downLoadTable = () => {
    window.open('/riskExample/exportExampleData?' + common.concatUrl(this.params));
  }
  @action
  showOrHiddenAddAndEditModal = (type = 1, record) => {
    this.showAddAndEditModal = type === 1;
    this.record = record;
  }
  // 保存新增编辑表单ref
  @action
  saveFormRef = (formRef) => {
    this.formRef = formRef;
  }
}

const store = new State();
export default store;
