// 排序校验规则,只能输入1-列表长度之内的整数
export const sortValidRule = (rule, value, func, store) => {
  const {
    dataSource,
    isAddModal
  } = store;
  const length = dataSource.length;
  // const sRex = '^([1-9]|[1-2]\\d|' + pageSize + ')$';
  const sRex = '^[1-9]\\d*$';
  const reg = new RegExp(sRex);
  if (
    value &&
    (!value.toString().match(reg) ||
    (isAddModal && value > length + 1) ||
    (!isAddModal && value > length))
  ) {
    // func(`请输入1~${length < pageSize ? isAddModal ? length + 1 : length : pageSize}之间的整数`);
    func(`请输入1~${isAddModal ? length + 1 : length}之间的整数`);
  } else {
    func();
  }
};
// 判断是否已经存在相同的URL
// url为需要匹配的URL，index为当前操作数据的排序
const hasUrl = (data, url, ind) => {
  return data.some((element, index, array) => {
    return url && element.url === url.trim() && index !== ind;
  });
};
// url校验规则,不能重名
export const urlValidRule = (rule, value, func, store) => {
  const {
    dataSource,
    currentIndex
  } = store;
  if (hasUrl(dataSource, value, currentIndex)) {
    func('URL地址已存在，请重新输入');
  } else {
    func();
  }
};
// 标签校验规则
export const tagsValidRule = (rule, value, func, tagsMaxSelected) => {
  if (value && Array.isArray(value) && (value.length > tagsMaxSelected)) {
    func(`标签最多不能超过${tagsMaxSelected}个`);
  } else {
    func();
  }
};
// 密码校验规则,只能是英文字母大小写，数字，特殊符号!@#.,，不能存在%
export const pwdValidRule = (rule, value, func) => {
  if (value && typeof value === 'string') {
    if (/%/.test(value)) {
      func('输入内容包含特殊字符，请重新输入');
    } else if (!/[\da-zA-Z!@#.,]{8,}/.test(value)) {
      func('密码格式错误');
    } else {
      func();
    }
  } else {
    func();
  }
};
// 账号校验规则
export const accountValidRule = (rule, value, func) => {
  if (value && typeof value === 'string' && /%/.test(value)) {
    func('输入内容包含特殊字符，请重新输入');
  } else {
    func();
  }
};
