/**
 * 选择标签
 */
import React from 'react';
import debounce from 'lodash/debounce';

import common from 'src/lib/common';

import { Select, Spin } from 'antd';

import styles from './index.less';

const Option = Select.Option;

class TagSelect extends React.Component {
  constructor(props) {
    super(props);
    this.lastFetchId = 0;
    this.fetchUser = debounce(this.fetchUser, 800);
    this.state = {
      data: null,
      fetching: false
    };
  }
  fetchUser = (value) => {
    this.lastFetchId += 1;
    const fetchId = this.lastFetchId;
    this.setState({ data: [], fetching: true });
    common.fetch('/tag/selectTags', {content: value, tagLevel: 2}, 'get')
      .then((body) => {
        if (fetchId !== this.lastFetchId) { // for fetch callback order
          return;
        }
        const data = (body.data && body.data.map(tag => ({
          text: tag.contents,
          value: tag.tagId
        }))) || [];
        this.setState({ data, fetching: false });
      });
  }
  handleChange = (value) => {
    this.props.onChange(value);
    this.setState({
      fetching: false
    });
  }
  render() {
    const { fetching, data } = this.state;
    const {tagsContent = [], value = []} = this.props;
    let sourceMap = [];
    sourceMap = data === null ? tagsContent : data;
    return (
      <div id="tagsContainer">
        <Select
          mode="multiple"
          placeholder="选择标签"
          notFoundContent={fetching ? <Spin size="small" /> : null}
          filterOption={false}
          onSearch={this.fetchUser}
          onChange={this.handleChange}
          className={styles.select}
          value={value}
          getPopupContainer={() => document.getElementById('tagsContainer')}
        >
          {sourceMap && sourceMap.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
        </Select>
      </div>
    );
  }
}

export default TagSelect;
