import React from 'react';
import { observer } from 'mobx-react';
import store from '../store';
import Type from '../type/index';
import styles from './index.less';

import {
  DatePicker,
  Form,
  Input,
  Select,
  Radio,
  Button
} from 'antd';
import moment from 'moment';
const FormItem = Form.Item;
const Option = Select.Option;
const RadioGroup = Radio.Group;
const { RangePicker } = DatePicker;
const dateFormat = 'YYYY-MM-DD';
// 风险等级枚举
const cheatGradeArr = [
  { value: '', text: '全部' },
  { value: '0', text: '0级作弊' },
  { value: '1', text: '1级作弊' },
  { value: '2', text: '2级作弊' },
  { value: '3', text: '3级作弊' },
  { value: '4', text: '4级作弊' },
  { value: '5', text: '5级作弊' },
  { value: '6', text: '6级作弊' }
];
// 处理状态枚举 全部改为-1
const reviewResultArr = [
  { value: null, text: '待处理' },
  { value: 1, text: '调分成' },
  { value: 2, text: '下线' },
  { value: 3, text: '暂不处理' },
  // { value: 4, text: '暂不处理，加入限流包' },
  // { value: 5, text: '调分成，加入限流包' },
  // { value: 6, text: '下线，加入限流包' },
  { value: -1, text: '全部' }
];
// 意见枚举 全部改为-1
const mediaDealOpinionArr = [
  { value: 1, text: '同意' },
  { value: 0, text: '不同意' },
  { value: -1, text: '全部' }
];
// 处理时间枚举 全部改为-1
const dealDateArr = [
  { value: 1, text: '上午11:30' },
  { value: 2, text: '下午14:00' },
  { value: -1, text: '全部' }
];

@observer
class SearchFilter extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false,
      time: [moment().subtract(1, 'days'), moment().subtract(0, 'days')]
    };
  }
  componentDidMount() {
    const { getRiskReviewer } = store;
    getRiskReviewer();
    this.search();
  }
  // 设置查询作弊等级
  chageCheatGrade = (type) => {
    const { setFieldsValue } = this.props.form;
    setFieldsValue({
      cheatGrade: type
    });
    this.search();
  }
  // 查询
  search = () => {
    const { updateParams, getDataList, getcheatGrade, getFinalDealMoney } = store;
    const { getFieldValue } = this.props.form;
    let timeRange = getFieldValue('time');
    let params = {
      startTime: timeRange[0].format(dateFormat),
      endTime: timeRange[1].format(dateFormat),
      slotId: getFieldValue('slotId') || '',
      appId: getFieldValue('appId') || '',
      riskReviewer: getFieldValue('riskReviewer'),
      cheatGrade: getFieldValue('cheatGrade'),
      // reviewResult: getFieldValue('reviewResult') || '',
      preResult: getFieldValue('preResult') || '',
      mediaDealOpinion: getFieldValue('mediaDealOpinion'),
      dealDate: getFieldValue('dealDate') || '',
      currentPage: 1
    };
    updateParams(params);
    getDataList();
    // 获取各作弊条数
    getcheatGrade();
    getFinalDealMoney();
  }
  // radio框 类型切换
  typeSearch = (e) => {
    const { updateParams } = store;
    updateParams({type: e.target.value});
    this.search();
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    const { riskReviewer } = store;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 16 }
      }
    };
    let slotIdProps = getFieldDecorator('slotId');
    let appIdProps = getFieldDecorator('appId');
    // 日期选择器
    let timeProps = getFieldDecorator('time', {
      initialValue: this.state.time
    });
    // 处理人
    let riskReviewerProps = getFieldDecorator('riskReviewer', {
      initialValue: ''
    });
    // 作弊等级
    let cheatGradeProps = getFieldDecorator('cheatGrade', {
      initialValue: ''
    });
    // 初步处理结果
    let preResultProps = getFieldDecorator('preResult', {
      initialValue: -1
    });
    // 媒体意见
    let mediaDealOpinionProps = getFieldDecorator('mediaDealOpinion', {
      initialValue: -1
    });
    // 媒体意见
    let dealDateProps = getFieldDecorator('dealDate', {
      initialValue: -1
    });
    // 最终处理结果
    // let reviewResultProps = getFieldDecorator('reviewResult', {
    //   initialValue: -1
    // });
    // 实时 离线 全部
    let typeProps = getFieldDecorator('type', {
      initialValue: 3
    });
    return (
      <div className={styles.search_warp}>
        <Form layout="inline" >
          <FormItem>
            {timeProps(
              <RangePicker
                format={dateFormat}
              />
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="广告位id"
          >
            {slotIdProps(
              <Input type="text" />
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="媒体id"
          >
            {appIdProps(
              <Input type="text" />
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="处理人"
          >
            {riskReviewerProps(
              <Select
                style={{ width: '100px' }}
                placeholder="Tags Mode"
              >
                {riskReviewer && riskReviewer.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
              </Select>
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="作弊等级"
          >
            {cheatGradeProps(
              <Select
                style={{ width: '120px' }}
                placeholder="Tags Mode"
              >
                {cheatGradeArr && cheatGradeArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
              </Select>
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="初步处理结果"
          >
            {preResultProps(
              <Select
                style={{ width: '180px' }}
                placeholder="Tags Mode"
              >
                {reviewResultArr && reviewResultArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
              </Select>
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="媒体处理意见"
          >
            {mediaDealOpinionProps(
              <Select
                style={{ width: '180px' }}
                placeholder="Tags Mode"
              >
                {mediaDealOpinionArr && mediaDealOpinionArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
              </Select>
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="处理时间"
          >
            {dealDateProps(
              <Select
                style={{ width: '120px' }}
                placeholder="Tags Mode"
              >
                {dealDateArr && dealDateArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
              </Select>
            )}
          </FormItem>
          {/* <FormItem
            {...formItemLayout}
            label="最终处理结果"
          >
            {reviewResultProps(
              <Select
                style={{ width: '180px' }}
                placeholder="Tags Mode"
              >
                {reviewResultArr && reviewResultArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
              </Select>
            )}
          </FormItem> */}
          <FormItem>
            <Button
              type="primary"
              htmlType="submit"
              onClick={this.search}
            >
              查询
            </Button>
          </FormItem>
          <br/>
          <FormItem>
            {typeProps(
              <RadioGroup onChange={this.typeSearch}>
                <Radio value={1}>只看实时</Radio>
                <Radio value={2}>只看离线</Radio>
                <Radio value={3}>查看全部</Radio>
              </RadioGroup>
            )}
          </FormItem>
        </Form>
        <Type chageCheatGrade={this.chageCheatGrade}/>
      </div>
    );
  }
}

const PageSearch = Form.create({})(SearchFilter);
export default PageSearch;
