import React from 'react';
import { observer } from 'mobx-react';
import { transaction } from 'mobx';

import {
  Modal,
  Button
} from 'antd';

import AddAndEditForm from '../../forms/addAndEditForm';

import store from '../../store';

const titles = ['编辑案例', '添加案例'];
@observer
class AddAndEditModal extends React.Component {
  handleOk = () => {
    const {
      saveStickItem,
      showOrHiddenAddAndEditModal,
      setContentChanged,
      formRef,
      record
    } = store;
    const { form } = formRef.props;
    const { validateFields } = form;
    validateFields((errors, values) => {
      if (errors) {
        console.log(errors);
      } else {
        const { url2Add, ...rest } = values;
        let imgChangeArr = [];
        url2Add.map(item => {
          if (item.response) {
            imgChangeArr.push(item.response.data.url);
          }
        });
        let params = {
          id: record && record.id ? record.id : '',
          exceptionDate: rest.curDate,
          exampleDemand: rest.exampleDemand,
          exampleFeatures: rest.exampleFeatures,
          exampleResult: rest.exampleResult,
          slotId: parseInt(rest.slotId)
        };
        transaction(() => {
          // 保存数据,设置内容为已改变并且隐藏弹窗
          saveStickItem({
            ...params,
            // 本地开发阶段临时判断是否为空
            // imgIds: imgIds.length ? (imgIds[0].url || imgIds[0].response.data.url) : []
            url2Add: imgChangeArr
          });
          setContentChanged(true);
          showOrHiddenAddAndEditModal(0);
        });
      }
    });
  }
  handleCancel = () => {
    const { showOrHiddenAddAndEditModal } = store;
    // 隐藏弹窗
    showOrHiddenAddAndEditModal(0);
  }
  render() {
    const { showAddAndEditModal, record, saveFormRef } = store;
    const title = record && record.slotId ? titles[0] : titles[1];
    return (
      <Modal
        visible={showAddAndEditModal}
        title={title}
        maskClosable={false}
        footer={[
          <Button key="back" onClick={this.handleCancel}>取消</Button>,
          <Button key="submit" type="primary" onClick={this.handleOk}>确定</Button>
        ]}
        onCancel={this.handleCancel}
        destroyOnClose={true}
      >
        <AddAndEditForm wrappedComponentRef={saveFormRef}/>
      </Modal>
    );
  }
}

export default AddAndEditModal;
