import React from 'react';
// import { observer } from 'mobx-react';
import styles from './index.less';
import store from '../store';

import {
  Form,
  Input,
  Button,
  Icon
} from 'antd';
const FormItem = Form.Item;

// @observer
class SearchFilter extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false
    };
  }
  componentDidMount() {
    const { getFieldList } = store;
    this.search();
    getFieldList();
  }

  // 查询
  search = () => {
    this.props.form.validateFields((errors, values) => {
      if (!!errors) {
        return;
      }
      const { updateParams, getDataList } = store;
      let params = {
        ruleName: values.ruleName || '',
        currentPage: 1
      };
      updateParams(params);
      getDataList();
    });
  }

  render() {
    const { getFieldDecorator } = this.props.form;
    let ruleNameProps = getFieldDecorator('ruleName');
    return (
      <div className={styles.search_warp}>
        <h2 className={styles.search_header}><a href={`#/ruleEngine/strategy`} className={styles.goback}><Icon type="left" /></a><span>规则管理</span></h2>
        <Form layout="inline" >
          <FormItem
            label="规则名"
          >
            {ruleNameProps(
              <Input type="text" />
            )}
          </FormItem>
          <FormItem>
            <Button
              type="primary"
              htmlType="submit"
              onClick={this.search}
            >
              查询
            </Button>
          </FormItem>

        </Form>
      </div>
    );
  }
}

const PageSearch = Form.create({})(SearchFilter);
export default PageSearch;
