import { observable, action } from 'mobx';
import { message } from 'antd';
import common from 'src/lib/common';

class State {
  // loading
  @observable
  dataIsLoading = false;
  // 请求参数
  @observable
  params = {
    'dateRange.from': '',
    'dateRange.to': '',
    dimension: '',
    stat: '',
    src: '',
    currentPage: 1,
    pageSize: 6
  };
  // 更新params
  @action
  updateParams = (params) => {
    this.params = Object.assign({}, this.params, params);
  }
  // table数据
  @observable
  dataList = {
    list: []
  };
  // 获取table数据
  @action
  getDataList = () => {
    this.dataIsLoading = true;
    common.fetch('/blacklist/list', this.params, 'get')
      .then(res => {
        this.dataIsLoading = false;
        this.dataList = res.data || [];
      });
  }
  // 启用禁用
  @action
  changeSatus = (params) => {
    common.fetch('/blacklist/enordis', params, 'post', {isJson: false})
      .then(res => {
        common.handleSuccess('修改成功！');
        this.getDataList();
      });
  }
  // 添加黑名单
  @action
  changeSatus = (params) => {
    common.fetch('/blacklist/enordis', params, 'post', {isJson: false})
      .then(res => {
        common.handleSuccess('修改成功！');
        this.getDataList();
      });
  }

  // 更新数据状态
  @action
  blacklistSave = (params) => {
    common.fetch('/blacklist/save', params, 'post', {isJson: false})
      .then(res => {
        if (res.code === 'E1000006') {
          message.warning(res.desc);
        } else {
          this.getDataList();
        }
      });
  }
  // 更新
  @action
  blacklistUpdate = (params) => {
    common.fetch('/blacklist/update', params, 'post', {isJson: false})
      .then(res => {
        this.getDataList();
      });
  }
  // 导出
  @action
  downLoadTable = (ids) => {
    let params = Object.assign({}, ids, this.params);
    window.open('/blacklist/export?' + common.concatUrl(params));
  }
}

const store = new State();
export default store;
