import React from 'react';
import { observer } from 'mobx-react';
import store from '../store';
import {
  Form,
  Input,
  Modal,
  Select
} from 'antd';
import moment from 'moment';
const FormItem = Form.Item;
const Option = Select.Option;
let TextArea = Input.TextArea;
const dateFormat = 'YYYY-MM-DD HH:mm:ss';
const dimension = [
  { value: 0, text: 'ip' },
  { value: 1, text: 'device_id' },
  { value: 2, text: 'consumer_id' }
];
const riskRankArr = [
  { value: 2, text: '高风险' },
  { value: 1, text: '中风险' },
  { value: 0, text: '低风险' }
];
const stat = [
  { value: 0, text: '启用' },
  { value: 1, text: '禁用' }
];
@observer
class Edit extends React.Component {
  handleOk = () => {
    this.props.form.validateFields((err, values) => {
      if (!err) {
        const { blacklistUpdate, blacklistSave } = store;
        const { getFieldValue } = this.props.form;
        let params = {
          dimension: getFieldValue('dimension'),
          stat: getFieldValue('stat'),
          src: getFieldValue('src'),
          memo: getFieldValue('memo'),
          val: getFieldValue('val'),
          riskRank: getFieldValue('riskRank'),
          gmtCreate: this.props.editObj.gmtCreate || '',
          creator: this.props.editObj.creator || '',
          id: this.props.editObj.id
        };
        this.props.isEdit ? blacklistUpdate(params) : blacklistSave(params);
        this.props.closeModal();
      }
    });
  };
  handleCancel = () => {
    this.props.closeModal();
  };
  render() {
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 8 }
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 16 }
      }
    };
    const { getFieldDecorator } = this.props.form;
    // 名单维度
    let dimensionProps = getFieldDecorator('dimension', {
      initialValue: this.props.editObj.dimension || 0
    });
    let valProps = getFieldDecorator('val', {
      initialValue: this.props.editObj.val || '',
      rules: [{
        required: true, message: '请输入！'
      }]
    });
    // 风险等级
    let riskRankProps = getFieldDecorator('riskRank', {
      initialValue: typeof this.props.editObj.riskRank === 'undefined' ? 2 : this.props.editObj.riskRank
    });
    // 状态
    let statProps = getFieldDecorator('stat', {
      initialValue: this.props.editObj.stat || 0
    });
    // 来源
    let srcProps = getFieldDecorator('src', {
      initialValue: this.props.editObj.src || ''
    });
    // 备注
    let memoProps = getFieldDecorator('memo', {
      initialValue: this.props.editObj.memo || '',
      rules: [{
        max: 64, message: '最多输入64个字符！'
      }]
    });
    return (
      <div>
        <Modal
          title={ this.props.isEdit ? '修改黑名单' : '添加黑名单'}
          width={400}
          visible={true}
          maskClosable={false}
          onOk={this.handleOk}
          onCancel={this.handleCancel}
          okText="确认"
          cancelText="取消"
        >
          <Form>
            <FormItem
              {...formItemLayout}
              label="名单维度"
            >
              {
                dimensionProps(
                  <Select
                    style={{ width: '100%' }}
                    placeholder="Tags Mode"
                    disabled={this.props.isEdit}
                  >
                    {dimension && dimension.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
                  </Select>
                )
              }
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="名单值"
            >
              {valProps(
                <Input type="text" />
              )}
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="风险等级"
            >
              {
                riskRankProps(
                  <Select
                    style={{ width: '100%' }}
                    placeholder="Tags Mode"
                  >
                    {riskRankArr && riskRankArr.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
                  </Select>
                )
              }
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="来源"
            >
              {srcProps(
                <Input type="text" />
              )}
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="状态"
            >
              {
                statProps(
                  <Select
                    style={{ width: '100%' }}
                    placeholder="Tags Mode"
                  >
                    {stat && stat.map((d, index) => <Option key={index} value={d.value}>{d.text}</Option>)}
                  </Select>
                )
              }
            </FormItem>
            <FormItem
              {...formItemLayout}
              label="备注："
            >
              {memoProps(
                <TextArea rows={3} />
              )}
            </FormItem>
            {this.props.isEdit ? <FormItem
              {...formItemLayout}
              label="更新人："
            >
              <div>{this.props.editObj.mender}</div>
            </FormItem> : null }
            {this.props.isEdit ? <FormItem
              {...formItemLayout}
              label="更新时间："
            >
              <div>{this.props.editObj.gmtModified ? moment(this.props.editObj.gmtModified).format(dateFormat) : ''}</div>
            </FormItem> : null }
          </Form>
        </Modal>
      </div>
    );
  }
}

const EditModal = Form.create({})(Edit);
export default EditModal;
