import React from 'react';
import { observer } from 'mobx-react';
import store from '../store';
import styles from './index.less';

import {
  Form,
  Input,
  Button
} from 'antd';
const FormItem = Form.Item;

@observer
class SearchFilter extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false
    };
  }
  componentDidMount() {
    this.search();
  }

  // 查询
  search = () => {
    this.props.form.validateFields((errors, values) => {
      if (!!errors) {
        return;
      }
      const { updateParams, getDataList } = store;
      let params = {
        sceneName: values.sceneName || '',
        currentPage: 1
      };
      updateParams(params);
      getDataList();
    });
  }

  render() {
    const { getFieldDecorator } = this.props.form;
    let sceneNameProps = getFieldDecorator('sceneName');
    return (
      <div className={styles.search_warp}>
        <Form layout="inline" >
          <FormItem
            label="场景"
          >
            {sceneNameProps(
              <Input type="text" />
            )}
          </FormItem>
          <FormItem>
            <Button
              type="primary"
              htmlType="submit"
              onClick={this.search}
            >
              查询
            </Button>
          </FormItem>

        </Form>
      </div>
    );
  }
}

const PageSearch = Form.create({})(SearchFilter);
export default PageSearch;
