import React from 'react';
import { Table, Button } from 'antd';
import styles from './index.less';
import { observer } from 'mobx-react';

import store from '../store';
import EditModal from '../modals/editModal';

@observer
class ScenceTable extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedRows: [],
      editObj: [],
      isEdit: false,
      show: false
    };
  }
  showModal = (isEdit, obj) => {
    if (isEdit && obj.sceneNames !== null) {
      const { checkField } = store;
      let ids = [];
      obj.sceneNames && obj.sceneNames.forEach(item => {
        ids.push(item.id);
      });
      let params = {
        fieldIds: ids
      };
      checkField(params);
    }
    this.setState({
      isEdit: isEdit,
      show: true,
      editObj: obj
    });
  }
  closeModal = () => {
    store.clearFieldArr();
    this.setState({
      show: false
    });
  }
  render() {
    const columns = [{
      title: '字段名称',
      dataIndex: 'name',
      key: 'name',
      width: 150
    }, {
      title: '字段类型',
      dataIndex: 'type',
      key: 'type',
      width: 150,
      render: (text, record, index) => {
        const type = text === '0' ? '数值' : '字符串';
        return type || '-';
      }
    }, {
      title: '场景',
      dataIndex: 'sceneNames',
      key: 'sceneNames',
      width: 150,
      render: (text, record, index) => {
        let sceneArr = [];
        let sceneNames = '';
        record.sceneNames && record.sceneNames.forEach(item => {
          sceneArr.push(item.sceneName);
        });
        sceneNames = sceneArr.join(', ');
        return sceneNames || '-';
      }
    }, {
      title: '描述',
      dataIndex: 'description',
      key: 'description',
      width: 150
    }, {
      title: '最近更新人',
      dataIndex: 'editor',
      key: 'editor',
      width: 150
    }, {
      title: '更新时间',
      dataIndex: 'gmtModifiedView',
      key: 'gmtModifiedView',
      width: 150
    }, {
      title: '操作',
      key: 'operates',
      width: 150,
      render: (text, record, index) => {
        const { checkIsRule } = store;
        return (
          <div>
            <a className={styles.link} onClick= {(e) => { this.showModal(true, record); }}>编辑</a>
            <a className={styles.link} onClick= {() => checkIsRule(record.id, record.name)}>删除</a>
          </div>
        );
      }
    }];
    const { dataIsLoading, dataList } = store;
    let _dataSource = dataList.list ? dataList.list.slice() : [];
    const paganationOpts = {
      defaultPageSize: 10,
      current: store.params.currentPage,
      total: dataList.totalCount,
      showTotal: (total) => { return `共${total}条`; },
      onChange: page => {
        const { getDataList, updateParams } = store;
        updateParams({currentPage: page});
        getDataList();
      }
    };
    return (
      <div>
        <Button className={styles.newBotton} type="primary" htmlType="submit" onClick={() => this.showModal(false, {})}>新建字段</Button>
        <Table
          // scroll={{ x: 2900 }}
          scroll={{ y: 500 }}
          rowKey="id"
          columns={columns}
          dataSource={_dataSource}
          pagination={true}
          pagination={paganationOpts}
          loading={dataIsLoading}
          locale={{ emptyText: '暂无数据' }}
        />
        {this.state.show ? <EditModal editObj={this.state.editObj} isEdit={this.state.isEdit} closeModal={this.closeModal}/> : null}
      </div>
    );
  }
}

export default ScenceTable;
