import {observable, action} from 'mobx';

import common from 'src/lib/common';
class State {
  @observable
  dataIsLoading = false;
  @observable
  params = {
    pageSize: 6,
    currentPage: 1
  };
  @action
  changeParams = (params = this.params) => {
    this.params = params;
  }
  @observable
  pagesize = 1;
  @action
  changepage = (page) => {
    this.pagesize = page;
  }
  @observable
  advertIndustryTags = []; // 行业标签
  @observable
  advertPromoteTags = []; // 落地页标签
  // 请求参数 @observable params = { };
  @observable
  innertablelist = [];
  @observable
  innertotal = {};
  @action
  getsecondReviewLists = (params = this.params) => {
    // 复审列表
    this.dataIsLoading = true;
    common.fetch('/plan/secondReviewList', params, 'get').then(res => {
      this.innertotal = res.data || {};
      this.dataIsLoading = false;
      this.innertablelist = res.data.list && res.data.list.map((ele, index) => {
        return Object.assign(ele, {key: `${ele.advertId} + ${Date.parse(new Date())}`});
      });
    });
  }
  // 行业标签
  @action
  getadvertIndustryTags = () => {
    common
      .fetch('/plan/advertIndustryTags', '', 'get')
      .then(res => {
        this.advertIndustryTags = res.data || [];
      });
  }
  // 落地页标签
  @action
  getadvertPromoteTags = () => {
    common
      .fetch('/plan/advertPromoteTags', '', 'get')
      .then(res => {
        this.advertPromoteTags = res.data || [];
      });
  }
  // 复审
  @observable
  ids = [];
  @observable
  checkres = {}
  @action
  changeids = (ids) => {
    this.ids = ids;
  }
  @action
  reCheck = (params) => {
    const promise = new Promise((resolve, reject) => {
      common.fetch('/plan/secondReview', params, 'post', {isJson: true}).then(res => {
        resolve(res);
        this.checkres = res;
      });
    });
    return promise;
  }
  @observable
  hasPermission = true;
  // 权限验证
  @action
  checkPermission = (params) => {
    const promise = new Promise((resolve, reject) => {
      common.fetch('/auth/getAuthList', params, 'get').then(res => {
        resolve(res);
        res.authList.includes('/plan/canAdvertReview') ? (this.hasPermission = true) : (this.hasPermission = false);
      });
    });
    return promise;
  }
  // 导出
  @action
  downLoadChecksTable = () => {
    window.open('/plan/secondReviewExport?' + common.concatUrl(this.params));
  }
}

const store = new State();
export default store;
