import React from 'react';
import { observer } from 'mobx-react';
import { withRouter } from 'react-router';
import styles from './index.less';
import Recheck from './recheck/index';
import Inspect from './inspect/index';
@observer
class Innercheck extends React.Component {
  state = {
    show: false
  }
  changeComponent = (type) => {
    if (type === 1) {
      this.setState({
        show: false
      });
    } else {
      this.setState({
        show: true
      });
    }
  }
  render() {
    return (
      <div className = { styles.pagead }>
        <div className = {styles.tablechange }>
          <span onClick = {() => this.changeComponent(1)} className = {!this.state.show ? styles.active : '' }>广告计划复审</span>
          <span onClick = {() => this.changeComponent(2)} className = {this.state.show ? styles.active : ''} >广告计划巡检</span>
        </div>
        {this.state.show ? <Inspect /> : <Recheck /> }
      </div>
    );
  }
};
export default withRouter(Innercheck);
