import React from 'react';
import store from '../store';
import { Modal } from 'antd';
const confirm = Modal.confirm;
export default function change(key, params, record) {
  return function(Wapper) {
    const { addOrUpdate, getDataList } = store;
    class NewComponent extends React.Component {
      onChange = (value) => {
        const { updateAddCaseModalObj } = store;
        if (key === 'isInExample') {
          updateAddCaseModalObj({
            show: true,
            record: record
          });
          return;
        }
        // switch 兼容后端
        if (key === 'isSuperiorReview' || key === 'isInExample') {
          if (value === true) {
            value = 1;
          } else {
            value = 0;
          }
        }
        params[key] = value;
        this.showConfirm(params);
      }
      // 二次确认框
      showConfirm = (params) => {
        confirm({
          title: '提示',
          content: '确认修改?',
          okText: '确定',
          okType: 'danger',
          cancelText: '取消',
          onOk() {
            addOrUpdate(params);
          },
          onCancel() {
            getDataList();
          }
        });
      }
      render() {
        return (
          React.cloneElement(
            Wapper,
            {
              onChange: this.onChange
            }
          )
        );
      }
    }
    return <NewComponent/>;
  };
}
