import React from 'react';
import {Popover} from 'antd';
import styles from './textAreahoc.less';

export default function change(key, params, record) {
  return function(Wapper) {
    class NewComponent extends React.Component {
      constructor(props) {
        super(props);
        this.state = {
          value: record[key]
        };
      }
      render() {
        const content = (
          <div className={styles.popover}>
            <p>{this.state.value}</p>
          </div>
        );
        let CopyWapper = React.cloneElement(
          Wapper,
          {
            value: this.state.value
          }
        );
        return (
          <Popover title={record.tableTitle} placement = "top" content={content}>
            {CopyWapper}
          </Popover>
        );
      }
    }
    return <NewComponent/>;
  };
}
