import React from 'react';
import {Upload, Modal} from 'antd';

export default function change(key, params, record) {
  return function(Wapper) {
    class NewComponent extends React.Component {
      constructor(props) {
        super(props);
        this.state = {
          previewVisible: false,
          previewImage: props.value,
          imgs: record.imgs
        };
      }
      // 处理预览框取消事件
      handleCancel = () => this.setState({ previewVisible: false })
      // 处理预览按钮点击事件
      handlePreview = (file) => {
        this.setState({
          previewImage: file.url || file.thumbUrl,
          previewVisible: true
        });
      }
      render() {
        const { previewVisible, previewImage } = this.state;
        let imgList = this.state.imgs && this.state.imgs.length && this.state.imgs.slice();
        let fileList = [];
        imgList && imgList.length && imgList.forEach(item => {
          let obj = {};
          obj.uid = item;
          obj.name = item;
          obj.url = item;
          obj.status = 'done';
          fileList.push(obj);
        });
        return (
          <div className="clearfix">
            <Upload
              className="uploadStyle"
              listType="picture-card"
              fileList={fileList}
              onPreview={this.handlePreview}
              showUploadList={{showRemoveIcon: false}}
            >
            </Upload>
            <Modal visible={previewVisible} footer={null} onCancel={this.handleCancel} className="modalStyle">
              <img alt="图片" className="width_100_percent" src={previewImage} />
            </Modal>
          </div>
        );
      }
    }
    return <NewComponent/>;
  };
}
