import React from 'react';
import {Popover} from 'antd';
import styles from './textAreaHoc.less';

export default function change(key, params, record) {
  return function(Wapper) {
    class NewComponent extends React.Component {
      constructor(props) {
        super(props);
        this.state = {
          value: record
        };
      }
      render() {
      // 递归生成菜单
        const generateMenu = (menuObj, treeLevel = 0, index) => {
          let dom = [];
          if (menuObj instanceof Array) {
            let list = [];
            menuObj && menuObj.length && menuObj.forEach((item, index) => {
              list.push(generateMenu(item, treeLevel + 1, index));
            });
            dom.push(
              <ul key={'uu' + treeLevel + index}>
                { list.map(function(item, index) {
                  return (
                    <div className={styles.menuRoot} key={'div' + treeLevel + index}>
                      {item}
                    </div>
                  );
                }) }
              </ul>
            );
          } else {
            let itemName = menuObj ? menuObj.tagName : false;
            dom.push(
              <span key={'span' + treeLevel + index}>
                <li className={styles.myLi}>
                  {itemName}
                </li>
              </span>
            );
            let next = menuObj ? menuObj.child : false;
            if (next) {
              let list = [];
              next.forEach((item, index) => {
                list.push(generateMenu(item, treeLevel + 1, index));
              });
              dom.push(
                <ul key={'ul' + treeLevel + index}>
                  {list}
                </ul>
              );
            }
          }
          return dom;
        };
        let CopyWapper = React.cloneElement(
          Wapper,
          {}
        );
        return (
          <Popover title={record.tableTitle} placement="top" content={generateMenu(record.labels)}>
            {CopyWapper}
          </Popover>
        );
      }
    }
    return <NewComponent/>;
  };
}
