import React from 'react';
import { observer } from 'mobx-react';
import store from '../store';
import { Table, Button, message, Modal, Icon } from 'antd';
import RecheckModal from '../modal';
import { formatDateTime } from '../../../../../lib/dataFormate';
import styles from './index.less';
import moment from 'moment';
const dateFormat = 'YYYY-MM-DD';
const confirm = Modal.confirm;
@observer
class Innertable extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      columns: '',
      tabledata: [],
      show: false,
      checkData: []
    };
  }
  // 巡检
  inspect = () => {
    if (this.state.checkData.length === 0) {
      message.warning('请勾选相应的广告计划数据');
      return false;
    } else {
      this.setState({
        show: true
      });
    }
  }
  // 下线
  offline = () => {
    const _this = this;
    if (this.state.checkData.length === 0) {
      message.warning('请勾选相应的广告计划数据');
      return false;
    } else {
      // 只有巡检的才可以下线
      const hasinepect = this.state.checkData.some((ele) => {
        return ele.inspectStatus === 0;
      });
      if (hasinepect) {
        message.warning('只有巡检过的广告计划才可以下线！');
        return false;
      }
      let _data = this.state.checkData;
      confirm({
        title: '是否确定下线该广告计划?',
        content: '',
        okText: '确定',
        cancelText: '取消',
        onOk() {
          let idparams = _data.map((ele) => ele.advertId);
          // 请求下线接口
          const { offlines, params, getsecondReviewLists } = store;
          offlines({ids: idparams}).then((res) => {
            if (res.success) {
              message.success('已下线');
              getsecondReviewLists(params);
              _this.setState({
                checkData: []
              });
            }
          });
        },
        onCancel() {
        }
      });
    }
  }
  componentDidMount() {
    const { getsecondReviewLists, checkPermission } = store;
    // 参数重置
    const _params = {
      'dateRange.from': moment().subtract(1, 'days').format(dateFormat),
      'dateRange.to': moment().subtract(0, 'days').format(dateFormat),
      advertId: '',
      advertMaster: '',
      advertName: '',
      ae: '',
      agentName: '',
      firstReviewer: '',
      goodsName: '',
      industryTag: '',
      promoteTag: '',
      sale: '',
      secondReviewStatus: 0,
      pageSize: 6,
      currentPage: 1
    };
    getsecondReviewLists(_params);
    checkPermission();
  }
  changestate(msg) {
    if (msg.type === 'ok') {
      this.setState({
        show: msg.status,
        checkData: []
      });
    } else {
      this.setState({
        show: msg.status
      });
    }
  }
  render() {
    // checkPermission
    const { innertablelist, innertotal, hasPermission, dataIsLoading } = store;
    let _innertablelist = innertablelist.slice();
    // 分页配置信息
    const paganationOpts = {
      defaultPageSize: 6,
      current: store.params.currentPage,
      total: innertotal.totalCount,
      showTotal: (total) => (`共${total}条`),
      onChange: page => {
        const { changeParams, getsecondReviewLists, params } = store;
        let _params = Object.assign(params, {
          currentPage: page
        });
        changeParams(_params);
        getsecondReviewLists(_params);
      }
    };
    const rowSelection = {
      onChange: (selectedRowKeys, selectedRows) => {
        // 需核查数据
        this.setState({
          checkData: selectedRows
        });
        const { changeids } = store;
        let _ids = selectedRows.map((ele) => ele.advertId);
        // 跟新id
        changeids(_ids);
      },
      selections: false,
      hideDefaultSelections: true,
      getCheckboxProps: (record) => {
        const _reject = record.inspectStatus === 3 || record.advertStatus === 1;
        return {
          disabled: _reject
        };
      }
    };
    const columns = [{
      title: '广告ID',
      dataIndex: 'advertId',
      width: 100,
      fixed: 'left',
      render: (text, record, index) => (
        <div>
          <a onClick={() => {
            const id = _innertablelist[index].advertId;
            window.open(`http://manager.tuia.cn/#/fastAuditAdvert/${id}`);
          }}>{text}</a>
        </div>
      )
    }, {
      title: '广告名称',
      dataIndex: 'advertName',
      width: 120,
      fixed: 'left',
      render: (text, record, index) => (
        <div>
          <a onClick={() => {
            const id = _innertablelist[index].advertId;
            window.open(`http://manager.tuia.cn/#/fastAuditAdvert/${id}`);
          }}>{text}</a>
        </div>
      )
    }, {
      title: '广告主名称',
      dataIndex: 'advertMaster'
    }, {
      title: '代理商名称',
      dataIndex: 'agentName'
    }, {
      title: '广告计划状态',
      dataIndex: 'advertStatusShow'
    },
    // {
    //   title: '来源',
    //   dataIndex: 'source',
    //   render: (text, record, index) => {
    //     switch (text) {
    //       case 0:
    //         text = '广告平台';
    //         break;
    //       case 1:
    //         text = '兑吧商品';
    //         break;
    //       default:
    //         text = '券库';
    //         break;
    //     }
    //     return (<span>{text}</span>);
    //   }
    // },
    {
      title: '巡检状态',
      dataIndex: 'inspectStatus',
      render: (text, record, index) => {
        switch (text) {
          case 0:
            text = '待巡检';
            break;
          default:
            text = '已巡检';
            break;
        }
        return (<span>{text}</span>);
      }
    }, {
      title: '最近巡检结果',
      dataIndex: 'inspectResult',
      render: (text, record, index) => {
        switch (text) {
          case 0:
            text = '待巡检';
            break;
          case 1:
            text = '巡检通过';
            break;
          case 2:
            text = '巡检拒绝';
            break;
          default:
            text = '巡检拒绝且下线';
            break;
        }
        return (<span>{text}</span>);
      }
    }, {
      title: '巡检累计次数',
      dataIndex: 'inspectCount',
      render: (text, record, index) => {
        return (<span>{text}</span>);
      }
    }, {
      title: '巡检备注',
      dataIndex: 'inspectMemo'
    }, {
      title: '最近巡检时间',
      dataIndex: 'inspectTime',
      render: (text, record, index) => {
        if (!text) {
          return '暂无';
        }
        return formatDateTime(text);
      }
    }, {
      title: '最近审核时间',
      dataIndex: 'lastReviewTime',
      render: (text, record, index) => {
        if (!text) {
          return '暂无';
        }
        return formatDateTime(text);
      }
    }, {
      title: '初审',
      dataIndex: 'firstReviewer'
    }, {
      title: 'AE',
      dataIndex: 'ae'
    }, {
      title: '销售',
      dataIndex: 'sale'
    }, {
      title: '复审',
      dataIndex: 'secondReviewer'
    }];
    const { downLoadInspectTable } = store;
    return (
      <div>
        <div className = { styles.table_options }>
          { hasPermission ? <Button type="primary" onClick = {this.inspect}>巡检</Button> : '' }
          <Button type="primary" onClick = {this.offline}>下线</Button>
          <Icon type="download" className={styles.down} onClick={downLoadInspectTable}/>
        </div>
        <Table
          rowSelection= { rowSelection }
          columns={columns}
          pagination={true}
          pagination={paganationOpts}
          scroll={{ x: 2000 }}
          locale={{ emptyText: '暂无数据' }}
          loading={ dataIsLoading }
          dataSource={ _innertablelist } />
        <RecheckModal ref = 'RecheckModal' changestate={ msg => this.changestate(msg) } show={this.state.show} />
      </div>
    );
  }
}
export default Innertable;
