import React from 'react';
import { observer } from 'mobx-react';
import store from '../store';
import { Table, Button, message, Icon } from 'antd';
import RecheckModal from '../modal';
import { formatDateTime } from '../../../../../lib/dataFormate';
import textAreaHoc from './textAreaHoc';
import styles from './index.less';
import moment from 'moment';
const dateFormat = 'YYYY-MM-DD';
message.config({
  maxCount: 1,
  duration: 2
});
@observer
class Innertable extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      columns: '',
      tabledata: [],
      show: false,
      checkData: []
    };
  }
  // 复审
  checks = () => {
    if (this.state.checkData.length === 0) {
      message.warning('请勾选相应的广告计划数据');
      return false;
    } else {
      const hascheck = this.state.checkData.some((ele) => {
        return ele.reviewStatus === 1 || ele.reviewStatus === 2;
      });
      if (hascheck) {
        message.warning('所选项目有项目已复审完毕,请核查后重新选择！');
      } else {
        this.setState({
          show: true
        });
      }
    }
  }
  componentDidMount() {
    const { getsecondReviewLists, checkPermission } = store;
    // 参数重置
    const _params = {
      'dateRange.from': moment().subtract(1, 'days').format(dateFormat),
      'dateRange.to': moment().subtract(0, 'days').format(dateFormat),
      advertId: '',
      advertMaster: '',
      advertName: '',
      ae: '',
      agentName: '',
      firstReviewer: '',
      goodsName: '',
      industryTag: '',
      promoteTag: '',
      sale: '',
      secondReviewStatus: 0,
      pageSize: 6,
      currentPage: 1
    };
    getsecondReviewLists(_params);
    checkPermission();
  }
  changestate(msg) {
    if (msg.type === 'ok') {
      this.setState({
        show: msg.status,
        checkData: []
      });
    } else {
      this.setState({
        show: msg.status
      });
    }
  }
  render() {
    const { innertablelist, innertotal, hasPermission, dataIsLoading } = store;
    let _innertablelist = innertablelist.slice();
    // 分页配置信息
    const paganationOpts = {
      defaultPageSize: 6,
      current: store.params.currentPage,
      total: innertotal.totalCount,
      showTotal: (total) => (`共${total}条`),
      onChange: page => {
        const { changeParams, getsecondReviewLists, params } = store;
        let _params = Object.assign(params, {
          currentPage: page
        });
        changeParams(_params);
        getsecondReviewLists(_params);
      }
    };
    // 跳转
    const rowSelection = {
      onChange: (selectedRowKeys, selectedRows) => {
        // 需核查数据
        this.setState({
          checkData: selectedRows
        });
        const { changeids } = store;
        let _ids = selectedRows.map((ele) => ele.advertId);
        // 跟新id
        changeids(_ids);
      }
    };
    const columns = [{
      title: '广告ID',
      dataIndex: 'advertId',
      fixed: 'left',
      width: 100,
      render: (text, record, index) => (
        <div>
          <a onClick={() => {
            const id = _innertablelist[index].advertId;
            window.open(`http://manager.tuia.cn/#/fastAuditAdvert/${id}`);
          }}>{text}</a>
        </div>
      )
    }, {
      title: '广告名称',
      dataIndex: 'advertName',
      fixed: 'left',
      width: 120,
      render: (text, record, index) => (
        <div>
          <a onClick={() => {
            const id = _innertablelist[index].advertId;
            window.open(`http://manager.tuia.cn/#/fastAuditAdvert/${id}`);
          }}>{text}</a>
        </div>
      )
    }, {
      title: '广告主名称',
      dataIndex: 'advertMaster'
    }, {
      title: '代理商名称',
      dataIndex: 'agentName'
    }, {
      title: '标签',
      dataIndex: 'labels',
      key: 'labels',
      width: 200,
      render: (text, record, index) => {
        let textArr = [];
        let textStr = '';
        text && text.forEach(item => {
          item.child && item.child.forEach(subItem => {
            subItem.child && subItem.child.forEach(subsubItem => {
              textArr.push(subsubItem.tagName);
              textStr = textArr.join(', ');
            });
          });
        });
        return textAreaHoc('labels', { labels: record.labels, id: record.id }, Object.assign({}, record, {tableTitle: '标签'}))(
          <span className={styles.limit}>{textStr}</span>
        );
      }
    },
    // {
    //   title: '来源',
    //   dataIndex: 'source',
    //   render: (text, record, index) => {
    //     switch (text) {
    //       case 0:
    //         text = '广告平台';
    //         break;
    //       case 1:
    //         text = '兑吧商品';
    //         break;
    //       default:
    //         text = '券库';
    //         break;
    //     }
    //     return (<span>{text}</span>);
    //   }
    // },
    {
      title: '复审状态',
      dataIndex: 'reviewStatus',
      render: (text, record, index) => {
        switch (text) {
          case 0:
            text = '待复审';
            break;
          default:
            text = '已复审';
            break;
        }
        return (<span>{text}</span>);
      }
    }, {
      title: '审核结果',
      dataIndex: 'secondResult',
      render: (text, record, index) => {
        if (record.reviewStatus === 0) {
          if (record.firstResult === 1) {
            text = '初审通过';
          } else {
            text = '初审拒绝';
          }
        } else {
          if (record.secondResult === 1) {
            text = '复审通过';
          } else {
            text = '复审拒绝';
          }
        }
        return (<span>{text}</span>);
      }
    }, {
      title: '审核备注',
      dataIndex: 'secondMemo'
    }, {
      title: '最近审核时间',
      dataIndex: 'lastReviewTime',
      render: (text, record, index) => {
        return formatDateTime(text);
      }
    }, {
      title: '初审',
      dataIndex: 'firstReviewer'
    }, {
      title: 'AE',
      dataIndex: 'ae'
    }, {
      title: '销售',
      dataIndex: 'sale'
    }, {
      title: '复审',
      dataIndex: 'secondReviewer'
    }];
    const { downLoadChecksTable } = store;
    return (
      <div>
        <div className = { styles.table_options }>
          { hasPermission ? <Button type="primary" onClick = {this.checks}>复审</Button> : '' }
          <Icon type="download" className={styles.down} onClick={downLoadChecksTable}/>
        </div>
        <Table
          rowSelection= { rowSelection }
          columns={columns}
          pagination={true}
          pagination={paganationOpts}
          scroll={{ x: 2000 }}
          loading = { dataIsLoading }
          locale={{ emptyText: '暂无数据' }}
          dataSource={ _innertablelist } />
        <RecheckModal ref = 'RecheckModal' changestate={ msg => this.changestate(msg) } show={this.state.show} />
      </div>
    );
  }
}
export default Innertable;
