import React from 'react';
import { Modal, Radio, Form, Input, message } from 'antd';
import { observer } from 'mobx-react';
import store from '../store';
const FormItem = Form.Item;
const RadioGroup = Radio.Group;
const { TextArea } = Input;
@observer
class RecheckModals extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      confirmLoading: false,
      needmemo: false
    };
  }
  afterClose = () => {
    this.setState({
      needmemo: false
    });
  }
  showModal = () => {
    this.setState({
      visible: true
    });
  }
  handleOk = () => {
    this.setState({
      ModalText: 'The modal will be closed after two seconds',
      confirmLoading: false
    });
    this.handleSearch();
  }
  handleCancel = () => {
    // 传值
    this.props.changestate({
      status: false,
      type: 'cancle'
    });
  }
  // 表单提交
  handleSearch = () => {
    this.props.form.validateFields((err, values) => {
      if (!err) {
        this.setState({
          confirmLoading: true
        });
        const { reCheck, ids } = store;
        reCheck({
          ids: ids,
          memo: this.props.form.getFieldValue('memo') || '',
          result: this.props.form.getFieldValue('result')
        }).then((res) => {
          // 更新列表
          if (res.success) {
            this.setState({
              confirmLoading: false
            });
            const { getsecondReviewLists, params } = store;
            getsecondReviewLists(params);
            this.props.changestate({
              status: false,
              type: 'ok'
            });
          } else {
            message.error(res.desc);
          }
        });
      };
    });
  }
  // 自定规则
  validatorRule = (rule, value, calls) => {
    let type = this.props.form.getFieldValue('result');
    if (type === 1) {
      calls();
    } else {
      if (!value) {
        calls('审核拒绝,请输入备注');
      } else if (value.length > 64) {
        calls('最多输入64个字');
      } else {
        calls();
      }
    }
  }
  // 类型改变
  onChangetype = (e) => {
    let val = e.target.value;
    if (val === 1) {
      this.setState({
        needmemo: false
      });
      // 重置
      this.props.form.resetFields();
    } else {
      this.setState({
        needmemo: true
      });
    }
  }
  textchange = (e) => {
  }
  render() {
    const { confirmLoading } = this.state;
    const { getFieldDecorator } = this.props.form;
    return (
      <div>
        <Modal title="复审"
          visible={this.props.show}
          onOk={this.handleOk}
          confirmLoading={confirmLoading}
          onCancel={this.handleCancel}
          okText = '确定'
          cancelText = '取消'
          afterClose = {this.afterClose}
          destroyOnClose
        >
          <Form
            className="ant-advanced-search-form"
            onSubmit={this.handleSearch}
          >
            <FormItem label='复审结果'>
              {getFieldDecorator('result', {
                initialValue: 1
              })(
                <RadioGroup onChange={this.onChangetype} >
                  <Radio value={1}>复审通过</Radio>
                  <Radio value={2}>复审拒绝</Radio>
                </RadioGroup>
              )}
            </FormItem>
            <FormItem label='备注'>
              {getFieldDecorator('memo', {
                rules: [
                  {
                    required: this.state.needmemo,
                    validator: this.validatorRule
                  }
                ]
              })(
                <TextArea rows={4} onChange = {this.textchange} />
              )}
            </FormItem>
          </Form>
        </Modal>
      </div>
    );
  }
}
const RecheckModal = Form.create({})(RecheckModals);

export default RecheckModal;
