import React from 'react';
import { observer } from 'mobx-react';
import styles from './index.less';

import store from '../../store';

import {
  Modal
} from 'antd';

// 处理状态枚举
const reviewResultArr = [
  { value: 0, text: '待处理' },
  { value: 1, text: '调分成' },
  { value: 2, text: '下线' },
  { value: 3, text: '暂不处理' },
  { value: 4, text: '暂不处理，加入限流包' },
  { value: 5, text: '调分成，加入限流包' },
  { value: 6, text: '下线，加入限流包' },
  { value: null, text: '全部' }
];

@observer
class Progress extends React.Component {
  componentDidMount() {

  }
  handleOk = () => {
  };
  handleCancel = () => {
    const { updateProcessModalObj } = store;
    updateProcessModalObj({show: false});
  }
  getReviewResult = (value) => {
    let label = '';
    reviewResultArr.forEach((item) => {
      if (item.value === value) {
        label = item.text;
      }
    });
    return label;
  }
  render() {
    return (
      <Modal
        title="处理进度"
        width={400}
        visible={this.props.processModalObj.show}
        onOk={this.handleOk}
        onCancel={this.handleCancel}
        okText="确认"
        cancelText="取消"
        footer={<div></div>}
      >
        <div className={styles.info}>
          <p>广告位id：{this.props.processModalObj.record.slotId}</p>
          <p>广告位名称：{this.props.processModalObj.record.slotName}</p>
          <p>日期：{this.props.processModalObj.record.curDate}</p>
        </div>
        {this.props.processModalObj && this.props.processModalObj.list.map((item, index) => {
          return (
            <div className={styles.item_log} key={index}>
              <div className={styles.title}>{item.reviewAction}</div>
              <div className={styles.list_info}>
                {item.reviewTime ? <p className={styles.item_info}>时间：{item.reviewTime}</p> : null}
                {item.reviewAction === '初步处理结果' || item.reviewAction === '最终处理结果' ? <p className={styles.item_info}>处理人：{item.riskReviewer}</p> : item.reviewAction === '通知媒体运营' || item.reviewAction === '媒体运营反馈' ? <p className={styles.item_info}>媒体运营：{item.riskReviewer}</p> : null}
                {item.reviewResult ? <p className={styles.item_info}>处理结果：{this.getReviewResult(item.reviewResult)}</p> : null}
                {item.reviewAction === '通知媒体运营' ? <p className={styles.item_info}>建议分成比例：{(item.rate / 100).toFixed(2) + '%'}</p> : item.reviewAction === '媒体运营反馈' ? <p className={styles.item_info}>最终分成比例：{(item.rate / 100).toFixed(2) + '%'}</p> : null}
                {item.mediaMemo ? <p className={styles.item_info}>备注：{item.mediaMemo}</p> : null}
              </div>
            </div>
          );
        })}
      </Modal>
    );
  }
}

export default Progress;
