import React from 'react';
import { observer } from 'mobx-react';
import styles from './index.less';
import store from '../../store';
import UploadImage from 'src/formElements/uploadImage';
import {
  Form,
  Input,
  Modal
} from 'antd';
const FormItem = Form.Item;
let TextArea = Input.TextArea;
@observer
class AddCase extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false
    };
  }
  handleOk = () => {
    this.props.form.validateFields((err, values) => {
      if (!err) {
        const { addCase } = store;
        const { getFieldValue } = this.props.form;
        let imgChangeArr = [];
        getFieldValue('imgIds') && getFieldValue('imgIds').map(item => {
          if (item.response) {
            imgChangeArr.push(item.response.data.url);
          }
        });
        let params = {
          exampleDemand: getFieldValue('exampleDemand'),
          url2Add: imgChangeArr,
          exampleFeatures: getFieldValue('exampleFeatures'),
          slotId: this.props.addCaseModalObj.record.slotId,
          slotName: this.props.addCaseModalObj.record.slotName,
          date: this.props.addCaseModalObj.record.curDate,
          riskAllId: this.props.addCaseModalObj.record.id,
          // 后端应不去读id
          id: this.props.addCaseModalObj.record.riskReviewId
        };
        addCase(params);
      }
    });
  };
  handleCancel = () => {
    const { updateAddCaseModalObj } = store;
    updateAddCaseModalObj({show: false});
  };
  render() {
    const { getFieldDecorator } = this.props.form;
    // 案例特征
    let exampleFeaturesProps = getFieldDecorator('exampleFeatures', {
      rules: [{
        required: true, message: '请输入！'
      }]
    });
    // 图片上传
    let imgIdsProps = getFieldDecorator('imgIds', {
      valuePropName: 'fileList',
      getValueFromEvent: (e) => {
        if (Array.isArray(e)) {
          return e;
        }
        return e && e.fileList;
      }
      // rules: [
      //   { type: 'array', required: true, message: '缩略图不能为空' }
      // ]
    });
    // 案例需求
    let exampleDemandProps = getFieldDecorator('exampleDemand', {
      rules: [{
        required: true, message: '请输入！'
      }]
    });
    return (
      <div>
        <Modal
          title="添加案例"
          width={400}
          visible={this.props.addCaseModalObj.show}
          onOk={this.handleOk}
          onCancel={this.handleCancel}
          okText="确认"
          cancelText="取消"
        >
          <div className={styles.info}>
            <p>广告位id：{this.props.addCaseModalObj.record.slotId}</p>
            <p>广告位名称：{this.props.addCaseModalObj.record.slotName}</p>
            <p>日期：{this.props.addCaseModalObj.record.curDate}</p>
          </div>
          <Form>
            <FormItem
              label="案例特征："
            >
              {exampleFeaturesProps(
                <TextArea rows={3} />
              )}
            </FormItem>
            <FormItem
              label="图片上传:"
            >
              {imgIdsProps(
                <UploadImage uploadButtonText='上传图片' onChange={this.handleChange} />
              )}
            </FormItem>
            <FormItem
              label="案例需求："
            >
              {exampleDemandProps(
                <TextArea rows={3} />
              )}
            </FormItem>
          </Form>
        </Modal>
      </div>
    );
  }
}

const AddCaseModal = Form.create({})(AddCase);
export default AddCaseModal;
