import React from 'react';
import common from 'src/lib/common';
import utils from 'src/lib/utils';

import {
  Layout
} from 'antd';

import Breadcrumb from 'src/components/breadcrumb';

import styles from './index.less';

const { Header: AntdHeader } = Layout;

class Header extends React.Component {
  handleQuit = () => {
    const _quit = () => {
      common.fetch('/sso/outLogin')
        .then((res) => {
          if (res.success) {
            utils.logout();
          }
        });
    };
    _quit();
  }
  render() {
    const { accountInfo = {} } = this.props;
    const { name = '' } = (accountInfo || {});
    return (
      <AntdHeader className={styles.header}>
        <div
          className={styles.logo}
          onClick={() => utils.jumpTo('/')}
        >
          {/* <img src="../../../static/favicon.ico" className={styles.img_wid} alt=""/> */}
          <img className = {styles.img_wid} src="data:image/png;base64,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" alt=""/>
          <span>风控管理平台</span>
        </div>
        <div className={styles.header_wrap}>
          <Breadcrumb show={false}/>
          <div className={styles.user_info_wrap}>
            <span>{name}</span>
            <span onClick={this.handleQuit}>退出</span>
          </div>
        </div>
      </AntdHeader>
    );
  }
}

export default Header;
