import React from 'react';
import { observer } from 'mobx-react';
import store from '../store';
import styles from './index.less';
@observer
class TypeSelect extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      loading: false
    };
  }
  cheatGradeChange(type) {
    this.props.chageCheatGrade(type);
  }
  render() {
    const { cheatGrade } = store;
    return (
      <div className={styles.list_type}>
        <div className={styles.item_type} onClick={() => { this.cheatGradeChange('6'); }}>
          <p>6级作弊</p>
          <p>{cheatGrade.cheatGradeSix}</p>
        </div>
        <div className={styles.item_type} onClick={() => { this.cheatGradeChange('5'); }}>
          <p>5级作弊</p>
          <p>{cheatGrade.cheatGradeFive}</p>
        </div>
        <div className={styles.item_type} onClick={() => { this.cheatGradeChange('4'); }}>
          <p>4级作弊</p>
          <p>{cheatGrade.cheatGradeFour}</p>
        </div>
        <div className={styles.item_type} onClick={() => { this.cheatGradeChange('3'); }}>
          <p>3级作弊</p>
          <p>{cheatGrade.cheatGradeThree}</p>
        </div>
        <div className={styles.item_type} onClick={() => { this.cheatGradeChange('2'); }}>
          <p>2级作弊</p>
          <p>{cheatGrade.cheatGradeTwo}</p>
        </div>
        <div className={styles.item_type} onClick={() => { this.cheatGradeChange('1'); }}>
          <p>1级作弊</p>
          <p>{cheatGrade.cheatGradeOne}</p>
        </div>
        <div className={styles.item_type} onClick={() => { this.cheatGradeChange('0'); }}>
          <p>0级作弊</p>
          <p>{cheatGrade.cheatGradeZero}</p>
        </div>
      </div>
    );
  }
}
export default TypeSelect;
