import React from 'react';
import { observer } from 'mobx-react';

import { Form, Input, DatePicker } from 'antd';

import UploadImage from 'src/formElements/uploadImage';

import store from '../../store';

import styles from './index.less';
import moment from 'moment';
const dateFormat = 'YYYY-MM-DD';
const FormItem = Form.Item;
let TextArea = Input.TextArea;
@observer
class AddAndEditForm extends React.Component {
  // 生成表单元素
  createFormItems = (items) => {
    const { getFieldDecorator } = this.props.form;
    return items.map(item => {
      const {
        hidden = false,
        label = '',
        id, option,
        item: itemComponent
      } = item;
      return (
        <FormItem
          className={ hidden ? styles.hidden : ''}
          label={ label }
          key={ id }
        >
          {getFieldDecorator(id, option)(itemComponent)}
        </FormItem>
      );
    });
  }
  // 生成表格配置参数
  createColumns = () => {
    const { record, fileArr } = store;
    let imgList = [];
    let formobj = {};
    if (record) {
      fileArr.imgs && fileArr.imgs.forEach(item => {
        let obj = {};
        obj.uid = item.id;
        obj.name = item.url;
        obj.url = item.url;
        obj.status = 'done';
        imgList.push(obj);
      });
      formobj.slotId = record.slotId;
      formobj.curDate = moment(record.curDate);
      formobj.exampleFeatures = record.exampleFeatures;
      formobj.url2Add = record.imgs;
      formobj.exampleDemand = record.exampleDemand;
      formobj.exampleResult = record.exampleResult;
    }
    // 处理元素为null的情况
    const fileList = record ? imgList : [];
    // 表单配置项
    const options = [
      {
        id: 'slotId',
        option: {
          initialValue: formobj.slotId,
          rules: [
            {required: true, message: '广告位id不能为空'}
          ]
        },
        item: <Input />,
        label: '广告位id：'
      },
      {
        id: 'curDate',
        option: {
          initialValue: formobj.curDate,
          rules: [
            {required: true, message: '异常时间点不能为空'}
          ]
        },
        item: <DatePicker format={dateFormat} />,
        label: '异常时间点:'
      },
      {
        id: 'url2Add',
        option: {
          valuePropName: 'fileList',
          getValueFromEvent: (e) => {
            if (Array.isArray(e)) {
              return e;
            }
            return e && e.fileList;
          },
          initialValue: fileList
        },
        item: <UploadImage uploadButtonText='上传图片'/>,
        label: '图片上传:'
      },
      {
        id: 'exampleFeatures',
        option: {
          initialValue: formobj.exampleFeatures,
          rules: [
            {required: true, message: '案例特征不能为空', whitespace: true}
          ]
        },
        item: <TextArea rows={3} />,
        label: '案例特征：'
      },
      {
        id: 'exampleDemand',
        option: {
          initialValue: formobj.exampleDemand,
          rules: [
            {required: true, message: '案例需求不能为空'}
          ]
        },
        item: <TextArea rows={3} />,
        label: '案例需求：'
      },
      {
        id: 'exampleResult',
        option: {
          initialValue: formobj.exampleResult
        },
        item: <TextArea rows={3} />,
        label: '案例结果：'
      }
    ];
    return options;
  }
  render() {
    const options = this.createColumns();
    return (
      <Form
        layout='horizontal'
        autoComplete="off"
      >
        { this.createFormItems(options) }
      </Form>
    );
  }
}

export default Form.create({})(AddAndEditForm);
