import React from 'react';
import { Table, Button, Row, Col, Modal } from 'antd';
import { observer } from 'mobx-react';
import store from '../store';
import EditModal from '../modals/editModal';
import styles from './index.less';
import moment from 'moment';
const dateFormat = 'YYYY-MM-DD HH:mm:ss';
const confirm = Modal.confirm;
const dimension = [
  { value: '', text: '全部' },
  { value: 0, text: 'ip' },
  { value: 1, text: 'device_id' },
  { value: 2, text: 'consumer_id' }
];
const stat = [
  { value: '', text: '全部' },
  { value: 0, text: '启用' },
  { value: 1, text: '禁用' }
];

function getDimension(key) {
  let title = '';
  dimension.forEach(item => {
    if (item.value === key) {
      title = item.text;
    }
  });
  return title;
}

function getStat(key) {
  let title = '';
  stat.forEach(item => {
    if (item.value === key) {
      title = item.text;
    }
  });
  return title;
}

@observer
class BlackTable extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      // 储存当前选中的行
      selectedRows: [],
      editObj: [],
      isEdit: false,
      show: false
    };
  }
  showModal = (isEdit, obj) => {
    this.setState({
      isEdit: isEdit,
      show: true,
      editObj: obj
    });
  }
  closeModal = () => {
    this.setState({
      show: false
    });
  }
  check(status) {
    if (this.state.selectedRows.length === 0) {
      confirm({
        title: '提示',
        content: '请勾选相应黑名单数据！',
        okText: '确定',
        okType: 'danger',
        cancelText: '取消'
      });
      return;
    }
    let _this = this;
    confirm({
      title: '提示',
      content: '是否启用/禁用该黑名单?',
      okText: '确定',
      okType: 'danger',
      cancelText: '取消',
      onOk() {
        _this.changeSatus(status);
      }
    });
  }
  changeSatus = (status) => {
    const { changeSatus } = store;
    let id = [];
    this.state.selectedRows.forEach(item => {
      id.push(item.id);
    });
    let params = {
      stat: status,
      id: id.join(',')
    };
    changeSatus(params);
  }
  // 下载
  downLoadTable = () => {
    const { downLoadTable } = store;
    let id = [];
    this.state.selectedRows.forEach(item => {
      id.push(item.id);
    });
    downLoadTable({ids: id});
  }
  render() {
    const { dataIsLoading, dataList } = store;
    let _dataSource = dataList.list ? dataList.list.slice() : [];
    const rowSelection = {
      onChange: (selectedRowKeys = [], selectedRows = []) => {
        this.setState({
          selectedRows
        });
      }
    };
    const columns = [{
      title: '名单维度',
      dataIndex: 'dimension',
      render: (text, record, index) => {
        return (
          getDimension(text)
        );
      }
    }, {
      title: '名单值',
      dataIndex: 'val'
    }, {
      title: '风险等级',
      dataIndex: 'riskRank',
      render: (text, record, index) => {
        const content = text === 0 ? '低风险' : text === 1 ? '中风险' : '高风险';
        return content;
      }
    }, {
      title: '状态',
      dataIndex: 'stat',
      render: (text, record, index) => {
        return (
          getStat(text)
        );
      }
    }, {
      title: '来源',
      dataIndex: 'src'
    }, {
      title: '备注',
      dataIndex: 'memo'
    }, {
      title: '创建时间',
      dataIndex: 'gmtCreate',
      render: (text, record, index) => {
        if (text === null) {
          return '';
        } else {
          return moment(text).format(dateFormat);
        }
      }
    }, {
      title: '创建人',
      dataIndex: 'creator'
    }, {
      title: '更新时间',
      dataIndex: 'gmtModified',
      render: (text, record, index) => {
        if (text === null) {
          return '';
        } else {
          return moment(text).format(dateFormat);
        }
      }
    }, {
      title: '更新人',
      dataIndex: 'mender'
    }, {
      title: '操作',
      key: 'operates',
      fixed: 'right',
      width: 150,
      render: (text, record, index) => (
        <div>
          <a className={styles.link} onClick= {(e) => { this.showModal(true, record); }}>编辑</a>
        </div>
      )
    }];
    // 分页配置信息
    const paganationOpts = {
      defaultPageSize: 6,
      current: store.params.currentPage,
      total: dataList.totalCount,
      showTotal: (total) => { return `共${total}条`; },
      onChange: page => {
        const { getDataList, updateParams } = store;
        updateParams({currentPage: page});
        getDataList();
      }
    };
    return (
      <div>
        <div className={styles.row_warp}>
          <Row>
            <Col span={2}>
              <Button
                type="primary"
                htmlType="submit"
                onClick={() => this.showModal(false, {})}
              >
                添加
              </Button>
            </Col>
            <Col span={2}>
              <Button
                type="primary"
                htmlType="submit"
                onClick={this.downLoadTable}
              >
                下载
              </Button>
            </Col>
            <Col span={2} offset={16}>
              <Button
                type="primary"
                htmlType="submit"
                onClick={() => this.check(0)}
              >
                启用
              </Button>
            </Col>
            <Col span={2}>
              <Button
                type="primary"
                htmlType="submit"
                onClick={() => this.check(1)}
              >
                禁用
              </Button>
            </Col>
          </Row>
        </div>
        <Table
          rowKey="id"
          rowSelection={rowSelection}
          columns={columns}
          loading={dataIsLoading}
          pagination={paganationOpts}
          locale={{ emptyText: '暂无数据' }}
          dataSource={_dataSource} />
        {this.state.show ? <EditModal editObj={this.state.editObj} isEdit={this.state.isEdit} closeModal={this.closeModal}/> : null}
      </div>
    );
  }
}
export default BlackTable;
