import React from 'react';
import { Link } from 'react-router';

import PermissionTool from 'src/lib/permissionTools';

import {
  Layout,
  Menu as AntdMenu,
  Icon
} from 'antd';

import MENU from './menuData';

import styles from './index.less';

const { SubMenu } = AntdMenu;
const { Sider } = Layout;

class Menu extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      collapsed: false
    };
  }
  // 菜单伸缩
  _toggle = () => {
    this.setState((preState, props) => ({
      collapsed: !preState.collapsed
    }));
  }
  // 生成一级菜单
  _createSubMenu = () => {
    return MENU.map((item) => {
      const { icon, title, key, auth } = item;
      const subMenuTitle = (
        <span>
          <Icon type={icon} />
          <span>{title}</span>
        </span>
      );
      return PermissionTool.ifRender(auth) ? (
        <SubMenu
          key={key}
          title={subMenuTitle}
        >
          { this._createItemMenu(item) }
        </SubMenu>
      ) : null;
    });
  }
  // 生成二级菜单
  _createItemMenu = (subMenuData) => {
    const { children } = subMenuData;
    return children.map((subItem) => {
      const { auth, key, route, title } = subItem;
      return PermissionTool.ifRender(auth) ? (
        <AntdMenu.Item key={key}>
          <Link to={route}>{title}</Link>
        </AntdMenu.Item>
      ) : null;
    });
  }
  // 获取当前路由
  getCurrentPaths = () => {
    const { currentLocation = {} } = this.props;
    const { pathname = '' } = currentLocation;
    let paths = pathname.split('/');
    paths.shift();
    if (paths.length === 1 && paths[0] === '') {
      paths = ['riskmng', 'auditsys', 'ruleEngine'];
    }
    return paths;
  }
  render() {
    const currentPaths = this.getCurrentPaths();
    const defaultOpenKeys = [currentPaths.shift()];
    const selectedKeys = [currentPaths.shift()];

    const { collapsed } = this.state;
    return (
      <Sider
        width={150}
        trigger={null}
        className={styles.slider}
        collapsible
        collapsed={collapsed}
      >
        <div className={styles.menu_top} onClick={this._toggle}>
          <Icon
            className="trigger"
            type={collapsed ? 'menu-unfold' : 'menu-fold'}
          />
        </div>
        <AntdMenu
          mode="inline"
          selectedKeys={selectedKeys}
          defaultOpenKeys={defaultOpenKeys}
          className={styles.menu}
        >
          {this._createSubMenu()}
        </AntdMenu>
      </Sider>
    );
  }
}

export default Menu;
