/**
 * Created by rockyl on 2020/9/19.
 */
import React, { useState, useEffect, useRef, forwardRef, useImperativeHandle, } from "react";
import './index.less';
import { useRotate } from "./helper";
import { compileTemplate, getChildBySlot } from "db-react-helper";
function classes(...classes) {
    return classes.join(' ');
}
/**
 * 圆形转盘
 * @desc 圆形转盘
 * @ctype DOM_COMPONENT
 */
function DiskTurntableImpl(props, ref) {
    let { renderBackground, renderOption, renderStartButton, } = props;
    const { options, angleOffset = 0, radian = 120, className, style, children, launchDuration, brakingDuration, maxSpeed, beforeLaunch, didStop, } = props;
    const fanRef = useRef();
    const [ctrl, setCtrl] = useState(undefined);
    useEffect(() => {
        const [launch, braking, stopAt] = useRotate(fanRef.current, { launchDuration, brakingDuration, maxSpeed });
        setCtrl({ launch, braking, stopAt });
        return function () {
            braking(0, true);
        };
    }, []);
    if (!renderBackground) {
        const child = getChildBySlot(children, 'background');
        if (child) {
            renderBackground = child;
        }
        else {
            console.warn(`属性[renderBackground]为空`);
        }
    }
    if (!renderStartButton) {
        const child = getChildBySlot(children, 'startButton');
        if (child) {
            renderStartButton = child;
        }
        else {
            console.warn(`属性[renderStartButton]为空`);
        }
    }
    if (!renderOption) {
        const child = getChildBySlot(children, 'option');
        if (child) {
            renderOption = child;
        }
        else {
            console.warn(`属性[renderOption]为空`);
        }
    }
    const optionCount = options.length;
    const perDeg = 360 / optionCount;
    useImperativeHandle(ref, () => ({
        stopAt(optionIndex) {
            let rotation = 360 - (optionIndex * perDeg);
            ctrl.stopAt(rotation);
        },
        launch() {
            beforeLaunch && beforeLaunch();
            ctrl.launch();
        },
        async braking(optionIndex, options = {}) {
            const { immediately, randomOffset } = options;
            let rotation = 360 - (optionIndex * perDeg); // + perDeg / 2
            if (randomOffset) {
                rotation += (perDeg / 2 - 3) * Math.random() * (Math.random() > 0.5 ? 1 : -1);
            }
            await ctrl.braking(rotation, immediately, didStop);
        },
    }), [ctrl]);
    function _renderBackground() {
        return typeof renderBackground === 'function' ? renderBackground() : renderBackground;
    }
    function _renderStartButton() {
        return typeof renderStartButton === 'function' ? renderStartButton() : renderStartButton;
    }
    function _renderOption(optionData, index) {
        let optionNode;
        if (typeof renderOption === 'function') {
            optionNode = renderOption(optionData, index);
        }
        else {
            optionNode = compileTemplate(renderOption, optionData, index);
        }
        return <div key={index} className="tt_option" style={{
                transform: `rotate(${perDeg * index + angleOffset}deg)`,
                transformOrigin: `center ${radian / 100}rem`
            }}>
			<div className="tt_option-wrapper">
				{optionNode}
			</div>
		</div>;
    }
    return <div className={classes('disk-turntable', className)} style={style}>
		<div className="tt_wrapper">
			<div className={classes('tt_fan')} ref={fanRef}>
				<div className={classes('tt_background')}>
					{_renderBackground()}
				</div>
				<div className={classes('tt_options')} style={{ transform: `translateY(-${radian / 100}rem)` }}>
					{options.map(_renderOption)}
				</div>
			</div>
			<div className={classes('tt_start-button')}>
				{_renderStartButton()}
			</div>
		</div>
	</div>;
}
// @ts-ignore
export const DiskTurntable = forwardRef(DiskTurntableImpl);
