import React, {useState, useRef, useEffect} from 'react'
import './Test.less';
import {DiskTurntable} from "./bundle"

function Test() {
	const options = [
		{name: '奖项0', icon: '//yun.duiba.com.cn/aurora/assets/2e4adf3d8646ffbd027038cb2c6627a6bca44e44.jpg'},
		{name: '奖项1', icon: '//yun.duiba.com.cn/aurora/assets/2e4adf3d8646ffbd027038cb2c6627a6bca44e44.jpg'},
		{name: '奖项2', icon: '//yun.duiba.com.cn/aurora/assets/2e4adf3d8646ffbd027038cb2c6627a6bca44e44.jpg'},
		{name: '奖项3', icon: '//yun.duiba.com.cn/aurora/assets/2e4adf3d8646ffbd027038cb2c6627a6bca44e44.jpg'},
		{name: '奖项4', icon: '//yun.duiba.com.cn/aurora/assets/2e4adf3d8646ffbd027038cb2c6627a6bca44e44.jpg'},
		{name: '奖项5', icon: '//yun.duiba.com.cn/aurora/assets/2e4adf3d8646ffbd027038cb2c6627a6bca44e44.jpg'},
	]

	const ttRef = useRef()

	useEffect(()=>{
		setTimeout(()=>{
			//ttRef.current.stopAt(3)
		}, 1000)
	}, [])

	async function onClickStartButton() {
		ttRef.current.launch()

		const index = await fetchApi()
		ttRef.current.braking(index, {randomOffset: false})
	}

	function fetchApi() {
		return new Promise(resolve => {
			setTimeout(() => {
				resolve(5)
			}, 1000)
		})
	}

	return (
		<div className="App">
			<DiskTurntable className='turntable'
			               ref={ttRef}
			               options={options}
			               angleOffset={0}
			               radian={120}
			               launchDuration={1000}
			               brakingDuration={1000}
			               maxSpeed={10}
			               renderBackground={<span className="bg"/>}
			               renderStartButton={<span className="start-button" onClick={onClickStartButton}/>}
			               renderOption={(optionData, index) => {
				               return <div className="option">
					               <img className="option-icon" src={optionData.icon}/>
					               <span className="option-name">{optionData.name}</span>
				               </div>
			               }}
			>
				{/*<span __slot="background" className="bg"/>
				<span __slot="startButton" className="start-button" onClick={onClickStartButton}/>
				<div __slot="option" className="option">
					<img __bind_src="icon" className="option-icon"/>
					<span __bind="name" className="option-name"/>
				</div>*/}
			</DiskTurntable>
		</div>
	)
}

export default Test;
