/**
 * Created by rockyl on 2021/9/10.
 */
const tickDelta = 1000 / 60;
export function useRotate(target, options = {}) {
    let _rotating = false;
    let _braking = false;
    let _brakingPromise;
    const [start, stop] = useTick(onTick, {
        onStart: () => {
            _rotating = true;
        },
        onStop: () => {
            _rotating = false;
        },
    });
    const { launchDuration = 3000, maxSpeed = 20, } = options;
    const brakingDuration = options.brakingDuration || launchDuration;
    let _stage = 0, _launchTime, _brakingTime, _speed = 0, _rotation, _nextBrakingR, _shouldBraking;
    let _didStop;
    function launch(force = false) {
        if (force || !_rotating) {
            _rotating = true;
            _rotation = getRotation(target);
            _shouldBraking = false;
            _launchTime = 0;
            _stage = 1;
            //console.log('开始启动')
            start();
        }
    }
    function braking(toRotation, immediately = false, didStop) {
        return new Promise(resolve => {
            _didStop = didStop;
            _brakingPromise = { resolve };
            if (!_rotating || _braking) {
                return;
            }
            if (immediately) {
                _braking = false;
                stop();
                _didStop && _didStop();
            }
            else {
                _braking = true;
                _brakingTime = 0;
                const t = brakingDuration / tickDelta;
                const deltaR = maxSpeed * t + (-maxSpeed / t) / 2 * (t * t); //计算制动的总角度
                _nextBrakingR = toRotation - deltaR % 360;
                if (_nextBrakingR < 0) {
                    _nextBrakingR += 360;
                }
                //console.log(deltaR, _nextBrakingR, deltaR + _nextBrakingR)
                _shouldBraking = true;
            }
        });
    }
    function stopAt(rotation) {
        _rotation = rotation;
        _speed = 0;
        _stage = 0;
        _applyRotation();
    }
    function onTick(delta, timestamp) {
        delta = tickDelta;
        switch (_stage) {
            case 0: //静止状态
                break;
            case 1: //启动阶段
                _launchTime += delta;
                const percentLaunch = Math.min(_launchTime / launchDuration, 1);
                if (percentLaunch == 1) {
                    _stage = 2;
                    //console.log('达到匀速')
                }
                _speed = maxSpeed * percentLaunch;
                break;
            case 2: //匀速阶段
                if (_shouldBraking) { //开始制动
                    const r = _rotation % 360;
                    //console.log(r)
                    if (r == _nextBrakingR) {
                        _stage = 3;
                        //console.log('开始减速', _rotation)
                    }
                    else if (r < _nextBrakingR && r + _speed >= _nextBrakingR) {
                        _rotation = _nextBrakingR - maxSpeed / 2;
                        _stage = 3;
                        //console.log('开始减速', _rotation)
                    }
                }
                break;
            case 3: //制动阶段
                _brakingTime += delta;
                const percentBraking = Math.min(_brakingTime / brakingDuration, 1);
                if (percentBraking == 1) {
                    _stage = 0;
                    _braking = false;
                    stop();
                    _brakingPromise && _brakingPromise.resolve();
                    _brakingPromise = null;
                    //console.log('停止', _rotation)
                    _didStop && _didStop();
                }
                _speed = maxSpeed * (1 - percentBraking);
                break;
        }
        _rotation += _speed;
        _applyRotation();
    }
    function _applyRotation() {
        target.style.transform = `rotate(${_rotation}deg)`;
        target.style.webkitTransform = `rotate(${_rotation}deg)`;
    }
    return [launch, braking, stopAt];
}
export function useTick(callback, options = {}) {
    let startTs, lastTs, shouldStop;
    function start() {
        shouldStop = false;
        startTs = undefined;
        lastTs = undefined;
        const { onStart } = options;
        onStart && onStart();
        requestAnimationFrame(tick);
    }
    function stop() {
        const { onStop } = options;
        onStop && onStop();
        shouldStop = true;
    }
    function tick(timestamp) {
        if (startTs === undefined) {
            startTs = timestamp;
        }
        const current = timestamp - startTs;
        if (lastTs === undefined) {
            lastTs = current;
        }
        const delta = current - lastTs;
        lastTs = current;
        callback(delta, current);
        if (shouldStop) {
            shouldStop = false;
        }
        else {
            requestAnimationFrame(tick);
        }
    }
    return [start, stop];
}
export function getRotation(target) {
    const st = getComputedStyle(target, null);
    const tr = st.getPropertyValue("-webkit-transform") ||
        st.getPropertyValue("-moz-transform") ||
        st.getPropertyValue("-ms-transform") ||
        st.getPropertyValue("-o-transform") ||
        st.getPropertyValue("transform") ||
        "none";
    if (tr === 'none') {
        return 0;
    }
    const values = tr.substring(7, tr.length - 2).split(',');
    const a = parseFloat(values[0]);
    const b = parseFloat(values[1]);
    return Math.round(Math.atan2(b, a) * (180 / Math.PI));
}
