# disk-turntable

圆形转盘  
实现了圆形转盘

![转盘](http://yun.duiba.com.cn/aurora/assets/c5be7bd36b6c7a525c80ac20ee0fef9313f02277.png)

## Install

`yarn add @spark/disk-turntable`

## Usage

```js
import {DiskTurntable, } from '@spark/disk-turntable'
```



### DiskTurntable

```jsx
//方式一：动态属性渲染样式
<DiskTurntable className='turntable'
               options={options}
               angleOffset={30}
               renderBackground={<span className="bg"/>}
               renderStartButton={<span className="start-button" onClick={onClickStartButton}/>}
               renderOption={(optionData, index) => {
	               return <div className="option">
		               <img className="option-icon" src={optionData.icon}/>
		               <span className="option-name">{optionData.name}</span>
	               </div>
               }}
/>

//方式二：静态子节点渲染样式
<DiskTurntable className='turntable'
               options={options}
               angleOffset={30}
>
	<span __slot="background" className="bg"/>
	<span __slot="startButton" className="start-button" onClick={onClickStartButton}/>
	<div __slot="option" className="option">
		<img __bind_src="icon" className="option-icon"/>
		<span __bind="name" className="option-name"/>
	</div>
</DiskTurntable>
```

#### 方式二说明

方式二是将各渲染元素当做子节点传入的，且有`__slot`特殊属性：

* `background` 转盘背景
* `startButton` 开始按钮
* `option` 单个奖项

#### 属性

|  属性  |  类型  |  必填  | 默认     | 描述                  |
| :----  |:----  | :----  |:----|:--------------------|
| children | React.ReactChildren | 否 |        | 子节点                 |
| angleOffset | number | 否 | `0`    | 角度偏移量               |
| radian | number | 否 | `120`  | 奖项半径                |
| options | any[] | 是 | true   | 奖项数组                |
| renderBackground | React.ReactElement | (() => React.ReactElement) | 否      |                     | 渲染转盘背景 |
| renderStartButton | React.ReactElement | (() => React.ReactElement) | 否      |                     | 渲染开始按钮 |
| renderOption | React.ReactElement | ((optionData: any, index: number) => React.ReactElement) | 否      |                     | 渲染单个奖项 |
| didLaunched | () => void  | 否 |        | 启动时回调               |
| didStop | () => void  | 否 |        | 停止时回调               |
| className | string | 否 |        | 设置样式类               |
| style | CSSProperties | 否 |        | 设置内联样式              |
| launchDuration | number | 否 | `3000` | 转盘启动时间              |
| brakingDuration | number | 否 | `3000` | 转盘制动时间，如果不设置则使用启动时间 |
| maxSpeed | number | 否 | `20`   | 转动最大角速度             |

#### 方法

`stopAt: (optionIndex: number)=>void`  
转盘立刻停驻在指定奖项的索引

`launch: ()=>void`  
转盘启动

`braking: (optionIndex: number, options?:{immediately?: boolean, randomOffset?: boolean})=>void`  
转盘制动：
> optionIndex: 最终落在奖项的索引  
> immediately: 是否立刻停止  
> randomOffset: 是否模拟随机角度偏移(效果更加真实)

## Contribute

1. `yarn dev` to develop package
2. `cd test && yarn && yarn dev` to develop test
